/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ObjectTypedValueWrapper;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.Set;

public class AnnotationParameterValue
extends ScanResultObject
implements Comparable<AnnotationParameterValue> {
    private String name;
    private ObjectTypedValueWrapper value;

    AnnotationParameterValue() {
    }

    AnnotationParameterValue(String name, Object value) {
        this.name = name;
        this.value = new ObjectTypedValueWrapper(value);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value == null ? null : this.value.get();
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.value != null) {
            this.value.setScanResult(scanResult);
        }
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> referencedClassNames) {
        if (this.value != null) {
            this.value.getClassNamesFromTypeDescriptors(referencedClassNames);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    void toString(StringBuilder buf) {
        buf.append(this.name);
        buf.append(" = ");
        this.toStringParamValueOnly(buf);
    }

    void toStringParamValueOnly(StringBuilder buf) {
        if (this.value == null) {
            buf.append("null");
        } else {
            Object paramVal = this.value.get();
            Class<?> valClass = paramVal.getClass();
            if (valClass.isArray()) {
                buf.append('{');
                int n = Array.getLength(paramVal);
                for (int j = 0; j < n; ++j) {
                    Object elt;
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append((elt = Array.get(paramVal, j)) == null ? "null" : elt.toString());
                }
                buf.append('}');
            } else if (paramVal instanceof String) {
                buf.append('\"');
                buf.append(paramVal.toString().replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
                buf.append('\"');
            } else if (paramVal instanceof Character) {
                buf.append('\'');
                buf.append(paramVal.toString().replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r"));
                buf.append('\'');
            } else {
                buf.append(paramVal.toString());
            }
        }
    }

    @Override
    public int compareTo(AnnotationParameterValue o) {
        int diff = this.name.compareTo(o.getName());
        if (diff != 0) {
            return diff;
        }
        Object p0 = this.getValue();
        Object p1 = o.getValue();
        if (p0 == null && p1 == null) {
            return 0;
        }
        if (p0 == null && p1 != null) {
            return -1;
        }
        if (p0 != null && p1 == null) {
            return 1;
        }
        return p0.toString().compareTo(p1.toString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationParameterValue)) {
            return false;
        }
        AnnotationParameterValue o = (AnnotationParameterValue)obj;
        int diff = this.compareTo(o);
        return diff != 0 ? false : (this.value == null && o.value == null ? true : this.value != null && o.value != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

