/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ReferenceTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeSignature;
import io.github.classgraph.utils.Parser;
import java.util.Set;

public class ArrayTypeSignature
extends ReferenceTypeSignature {
    private final TypeSignature elementTypeSignature;
    private final int numDims;

    ArrayTypeSignature(TypeSignature elementTypeSignature, int numDims) {
        this.elementTypeSignature = elementTypeSignature;
        this.numDims = numDims;
    }

    public TypeSignature getElementTypeSignature() {
        return this.elementTypeSignature;
    }

    public int getNumDimensions() {
        return this.numDims;
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.elementTypeSignature != null) {
            this.elementTypeSignature.setScanResult(scanResult);
        }
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> classNameListOut) {
        this.elementTypeSignature.getClassNamesFromTypeDescriptors(classNameListOut);
    }

    public int hashCode() {
        return this.elementTypeSignature.hashCode() + this.numDims * 15;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayTypeSignature)) {
            return false;
        }
        ArrayTypeSignature o = (ArrayTypeSignature)obj;
        return o.elementTypeSignature.equals(this.elementTypeSignature) && o.numDims == this.numDims;
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (!(other instanceof ArrayTypeSignature)) {
            return false;
        }
        ArrayTypeSignature o = (ArrayTypeSignature)other;
        return o.elementTypeSignature.equalsIgnoringTypeParams(this.elementTypeSignature) && o.numDims == this.numDims;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.elementTypeSignature.toString());
        for (int i = 0; i < this.numDims; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    static ArrayTypeSignature parse(Parser parser, String definingClassName) throws Parser.ParseException {
        int numArrayDims = 0;
        while (parser.peek() == '[') {
            ++numArrayDims;
            parser.next();
        }
        if (numArrayDims > 0) {
            TypeSignature elementTypeSignature = TypeSignature.parse(parser, definingClassName);
            if (elementTypeSignature == null) {
                throw new Parser.ParseException(parser, "elementTypeSignature == null");
            }
            return new ArrayTypeSignature(elementTypeSignature, numArrayDims);
        }
        return null;
    }
}

