/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class ClasspathOrModulePathEntry {
    public ClassLoader[] classLoaders;
    private final String pathToResolveAgainst;
    private final String relativePath;
    private String jarfilePackageRoot = "";
    private final NestedJarHandler nestedJarHandler;
    private String resolvedPathCached;
    private boolean resolvedPathIsCached;
    private boolean isHttpURL;
    private boolean isHttpURLIsCached;
    private boolean isJrtURL;
    private boolean isJrtURLIsCached;
    private ModuleRef moduleRef;
    private File fileCached;
    private boolean fileIsCached;
    private String canonicalPathCached;
    private boolean canonicalPathIsCached;
    private boolean isFileCached;
    private boolean isFileIsCached;
    private boolean isDirectoryCached;
    private boolean isDirectoryIsCached;
    private boolean existsCached;
    private boolean existsIsCached;
    private ScanSpec scanSpec;

    public ClasspathOrModulePathEntry(String pathToResolveAgainst, String relativePath, ClassLoader[] classLoaders, NestedJarHandler nestedJarHandler, ScanSpec scanSpec, LogNode log) {
        this.classLoaders = classLoaders;
        this.pathToResolveAgainst = pathToResolveAgainst;
        this.nestedJarHandler = nestedJarHandler;
        this.scanSpec = scanSpec;
        this.relativePath = relativePath.endsWith("!") ? relativePath.substring(0, relativePath.length() - 1) : (relativePath.endsWith("!/") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!/") ? relativePath.substring(0, relativePath.length() - 3) : relativePath)));
    }

    public ClasspathOrModulePathEntry(ModuleRef moduleRef, NestedJarHandler nestedJarHandler, LogNode log) {
        ClassLoader[] classLoaderArray;
        if (moduleRef == null) {
            throw new IllegalArgumentException("moduleRef cannot be null");
        }
        this.moduleRef = moduleRef;
        ClassLoader classLoader = moduleRef.getClassLoader();
        if (classLoader == null) {
            classLoaderArray = null;
        } else {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = classLoader;
        }
        this.classLoaders = classLoaderArray;
        this.pathToResolveAgainst = "";
        this.nestedJarHandler = nestedJarHandler;
        this.relativePath = moduleRef.getLocationStr();
    }

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public String getResolvedPath() {
        if (!this.resolvedPathIsCached) {
            this.resolvedPathCached = FastPathResolver.resolve(this.pathToResolveAgainst, this.relativePath);
            this.resolvedPathIsCached = true;
        }
        return this.resolvedPathCached;
    }

    public boolean isHttpURL() {
        if (!this.isHttpURLIsCached) {
            String resolvedPath = this.getResolvedPath();
            this.isHttpURL = resolvedPath.regionMatches(true, 0, "http://", 0, 7) || resolvedPath.regionMatches(true, 0, "https://", 0, 8);
            this.isHttpURLIsCached = true;
        }
        return this.isHttpURL;
    }

    public boolean isJrtURL() {
        if (!this.isJrtURLIsCached) {
            String resolvedPath = this.getResolvedPath();
            this.isJrtURL = resolvedPath.regionMatches(true, 0, "jrt:/", 0, 5);
            this.isJrtURLIsCached = true;
        }
        return this.isJrtURL;
    }

    public ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    public File getFile(LogNode log) throws IOException {
        if (!this.fileIsCached) {
            String path = this.getResolvedPath();
            if (path == null) {
                throw new IOException("Path " + this.relativePath + " could not be resolved relative to " + this.pathToResolveAgainst);
            }
            if (this.isJrtURL) {
                throw new IOException("Cannot use jrt:/ URL for non-module classpath entry " + this.relativePath);
            }
            int lastPlingIdx = path.lastIndexOf(33);
            if (lastPlingIdx < 0) {
                this.fileCached = new File(path);
            } else if (!this.scanSpec.performScan) {
                int firstPlingIdx = path.indexOf(33);
                String basePath = path.substring(0, firstPlingIdx);
                this.fileCached = new File(basePath);
            } else {
                try {
                    Map.Entry<File, Set<String>> innermostJarAndRootRelativePaths = this.nestedJarHandler.getInnermostNestedJar(path, log);
                    if (innermostJarAndRootRelativePaths != null) {
                        File innermostJar = innermostJarAndRootRelativePaths.getKey();
                        Set<String> rootRelativePaths = innermostJarAndRootRelativePaths.getValue();
                        String packageRoot = path.substring(lastPlingIdx + 1);
                        while (packageRoot.startsWith("/")) {
                            packageRoot = packageRoot.substring(1);
                        }
                        if (!packageRoot.isEmpty() && rootRelativePaths.contains(packageRoot)) {
                            this.jarfilePackageRoot = packageRoot;
                        }
                        this.fileCached = innermostJar;
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (log != null) {
                        log.log("Exception while locating jarfile " + this.relativePath, e);
                    }
                    throw new IOException("Exception while locating jarfile " + this.relativePath + " : " + e);
                }
            }
            while (this.jarfilePackageRoot.startsWith("/")) {
                this.jarfilePackageRoot = this.jarfilePackageRoot.substring(1);
            }
            if (this.fileCached == null || !FileUtils.canRead(this.fileCached)) {
                throw new IOException("Could not locate file " + (this.fileCached == null ? this.relativePath : this.fileCached) + (this.relativePath.equals(path) ? "" : " -- resolved to: " + path));
            }
            this.isFileCached = this.fileCached.isFile();
            this.isFileIsCached = true;
            if (lastPlingIdx > 0 && !this.isFileCached) {
                throw new IOException("Expected a jarfile, but found a directory: " + path);
            }
            try {
                this.fileCached = this.fileCached.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IOException("Could not canonicalize path " + path + " : " + e);
            }
            catch (SecurityException e) {
                throw new IOException("Could not canonicalize path " + path + " : " + e);
            }
            this.fileIsCached = true;
        }
        return this.fileCached;
    }

    public String getJarfilePackageRoot() {
        return this.jarfilePackageRoot;
    }

    public String getCanonicalPath(LogNode log) throws IOException {
        if (!this.canonicalPathIsCached) {
            File file = this.getFile(log);
            this.canonicalPathCached = FastPathResolver.resolve(file.getPath());
            this.canonicalPathIsCached = true;
        }
        return this.canonicalPathCached;
    }

    public boolean isFile(LogNode log) throws IOException {
        if (!this.isFileIsCached) {
            this.isFileCached = this.getFile(log).isFile();
            this.isFileIsCached = true;
        }
        return this.isFileCached;
    }

    public boolean isDirectory(LogNode log) throws IOException {
        if (!this.isDirectoryIsCached) {
            this.isDirectoryCached = this.getFile(log).isDirectory();
            this.isDirectoryIsCached = true;
        }
        return this.isDirectoryCached;
    }

    public boolean isClassfile() {
        return FileUtils.isClassfile(this.getResolvedPath());
    }

    private boolean exists(LogNode log) throws IOException {
        if (!this.existsIsCached) {
            this.existsCached = FileUtils.canRead(this.getFile(log));
            this.existsIsCached = true;
        }
        return this.existsCached;
    }

    public boolean isValidClasspathElement(ScanSpec scanSpec, LogNode log) {
        String path = this.getResolvedPath();
        if (this.isJrtURL || this.moduleRef != null) {
            return true;
        }
        try {
            boolean isDirectory;
            if (!this.exists(log)) {
                if (log != null) {
                    log.log("Classpath element does not exist: " + path);
                }
                return false;
            }
            boolean isFile = this.isFile(log);
            if (isFile != !(isDirectory = this.isDirectory(log))) {
                if (log != null) {
                    log.log("Ignoring invalid classpath element: " + path);
                }
                return false;
            }
            if (isFile) {
                String canonicalPath = this.getCanonicalPath(log);
                if (scanSpec.blacklistSystemJarsOrModules && JarUtils.isJREJar(canonicalPath, scanSpec, log)) {
                    if (log != null) {
                        log.log("Ignoring JRE jar: " + path);
                    }
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Ignoring invalid classpath element: " + path + " : " + e);
            }
            return false;
        }
    }

    public int hashCode() {
        return this.getResolvedPath().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClasspathOrModulePathEntry)) {
            return false;
        }
        ClasspathOrModulePathEntry other = (ClasspathOrModulePathEntry)o;
        return this.getResolvedPath().equals(other.getResolvedPath());
    }

    public String toString() {
        if (this.isFileCached && this.fileCached != null && !FastPathResolver.resolve(this.fileCached.toString()).equals(this.getResolvedPath())) {
            return this.getResolvedPath() + " -> " + this.fileCached;
        }
        return this.getResolvedPath();
    }
}

