/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.i18n;

import java.util.Arrays;
import java.util.Locale;
import org.geotools.util.Arguments;
import org.geotools.util.XArray;

public final class Locales {
    private Locales() {
    }

    public static Locale[] getAvailableLanguages() {
        return new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN};
    }

    public static Locale[] getAvailableLocales() {
        Locale[] languages = Locales.getAvailableLanguages();
        Locale[] locales = Locale.getAvailableLocales();
        int count = 0;
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            if (!Locales.containsLanguage(languages, locale)) continue;
            locales[count++] = locale;
        }
        locales = XArray.resize(locales, count);
        return locales;
    }

    private static boolean containsLanguage(Locale[] locales, Locale language) {
        String code = language.getLanguage();
        for (int i = 0; i < locales.length; ++i) {
            if (!code.equals(locales[i].getLanguage())) continue;
            return true;
        }
        return false;
    }

    public static String[] getAvailableLocales(Locale locale) {
        Locale[] locales = Locales.getAvailableLocales();
        Object[] display = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            display[i] = locales[i].getDisplayName(locale);
        }
        Arrays.sort(display);
        return display;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        String[] locales = Locales.getAvailableLocales(arguments.locale);
        for (int i = 0; i < locales.length; ++i) {
            arguments.out.println(locales[i]);
        }
    }
}

