/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.text.ChoiceFormat;
import org.geotools.metadata.i18n.Errors;

public final class XMath {
    public static final double LN10 = 2.302585092994046;

    private XMath() {
    }

    @Deprecated
    public static double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    @Deprecated
    public static double log10(double x) {
        return Math.log(x) / 2.302585092994046;
    }

    @Deprecated
    public static double pow10(double x) {
        return org.geotools.metadata.math.XMath.pow10(x);
    }

    @Deprecated
    public static strictfp double pow10(int x) {
        return org.geotools.metadata.math.XMath.pow10(x);
    }

    @Deprecated
    public static int sgn(double x) {
        return org.geotools.metadata.math.XMath.sgn(x);
    }

    @Deprecated
    public static int sgn(float x) {
        return org.geotools.metadata.math.XMath.sgn(x);
    }

    @Deprecated
    public static int sgn(long x) {
        return org.geotools.metadata.math.XMath.sgn(x);
    }

    @Deprecated
    public static int sgn(int x) {
        return org.geotools.metadata.math.XMath.sgn(x);
    }

    @Deprecated
    public static short sgn(short x) {
        return org.geotools.metadata.math.XMath.sgn(x);
    }

    @Deprecated
    public static byte sgn(byte x) {
        return org.geotools.metadata.math.XMath.sgn(x);
    }

    @Deprecated
    public static double round(double value, int flu) {
        return org.geotools.metadata.math.XMath.roundIfAlmostInteger(value, flu);
    }

    @Deprecated
    public static double fixRoundingError(double value, int n) {
        return org.geotools.metadata.math.XMath.trimDecimalFractionDigits(value, 4, n);
    }

    @Deprecated
    public static int countFractionDigits(double value) {
        return org.geotools.metadata.math.XMath.countDecimalFractionDigits(value);
    }

    private static float next(float f, boolean positive) {
        int SIGN = Integer.MIN_VALUE;
        int POSITIVEINFINITY = 2139095040;
        if (Float.isNaN(f)) {
            return f;
        }
        if (f == 0.0f) {
            float smallestPositiveFloat = Float.intBitsToFloat(1);
            return positive ? smallestPositiveFloat : -smallestPositiveFloat;
        }
        int bits = Float.floatToIntBits(f);
        int magnitude = bits & Integer.MAX_VALUE;
        if (bits > 0 == positive) {
            if (magnitude != 2139095040) {
                ++magnitude;
            }
        } else {
            --magnitude;
        }
        int signbit = bits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitude | signbit);
    }

    public static float next(float f) {
        return XMath.next(f, true);
    }

    public static float previous(float f) {
        return XMath.next(f, false);
    }

    public static double next(double f) {
        return ChoiceFormat.nextDouble(f);
    }

    public static double previous(double f) {
        return ChoiceFormat.previousDouble(f);
    }

    public static double rool(Class type, double value, int amount) throws IllegalArgumentException {
        if (Double.class.equals((Object)type)) {
            if (amount < 0) {
                do {
                    value = XMath.previous(value);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    value = XMath.next(value);
                } while (--amount != 0);
            }
            return value;
        }
        if (Float.class.equals((Object)type)) {
            float vf = (float)value;
            if (amount < 0) {
                do {
                    vf = XMath.previous(vf);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    vf = XMath.next(vf);
                } while (--amount != 0);
            }
            return vf;
        }
        if (XMath.isInteger(type)) {
            return value + (double)amount;
        }
        throw new IllegalArgumentException(Errors.format(199, type));
    }

    @Deprecated
    public static float toNaN(int index) throws IndexOutOfBoundsException {
        return org.geotools.metadata.math.XMath.toNaN(index);
    }

    @Deprecated
    public static boolean isReal(Class<?> type) {
        return type != null && Double.class.equals(type) || Float.class.equals(type);
    }

    @Deprecated
    public static boolean isInteger(Class<?> type) {
        return type != null && Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type);
    }

    @Deprecated
    public static int getBitCount(Class<?> type) {
        if (Double.class.equals(type)) {
            return 64;
        }
        if (Float.class.equals(type)) {
            return 32;
        }
        if (Long.class.equals(type)) {
            return 64;
        }
        if (Integer.class.equals(type)) {
            return 32;
        }
        if (Short.class.equals(type)) {
            return 16;
        }
        if (Byte.class.equals(type)) {
            return 8;
        }
        if (Character.class.equals(type)) {
            return 16;
        }
        if (Boolean.class.equals(type)) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public static Class<?> primitiveToWrapper(Class<?> type) {
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        return type;
    }

    @Deprecated
    public static <T> T valueOf(Class<T> type, String value) throws IllegalArgumentException, NumberFormatException {
        if (value == null) {
            return null;
        }
        if (Double.class.equals(type)) {
            return (T)Double.valueOf(value);
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(value);
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(value);
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(value);
        }
        if (Short.class.equals(type)) {
            return (T)Short.valueOf(value);
        }
        if (Byte.class.equals(type)) {
            return (T)Byte.valueOf(value);
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(value);
        }
        throw new IllegalArgumentException(Errors.format(187, type));
    }
}

