/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.util.Objects;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.EquatorialStereographic;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.referencing.operation.projection.StereographicUSGS;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.util.InternationalString;

public abstract class Stereographic
extends MapProjection {
    private static final long serialVersionUID = -176731870235252852L;
    private static final double EPSILON = 1.0E-6;
    private final ParameterDescriptorGroup descriptor;

    Stereographic(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
        super(parameters, descriptor.descriptors());
        this.descriptor = descriptor;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptor;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Stereographic that = (Stereographic)object;
            return Utilities.equals((Object)this.descriptor, (Object)that.descriptor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.descriptor);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 1243300263948365065L;
        static final InternationalString NAME = Vocabulary.formatInternational((int)208);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic"), new NamedIdentifier(Citations.GEOTIFF, "CT_Stereographic"), new NamedIdentifier(Citations.GEOTOOLS, NAME)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            this(PARAMETERS);
        }

        protected Provider(ParameterDescriptorGroup parameters) {
            super(parameters);
        }

        public Class<PlanarProjection> getOperationType() {
            return PlanarProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            double latitudeOfOrigin = Math.abs(MapProjection.AbstractProvider.doubleValue(LATITUDE_OF_ORIGIN, parameters));
            boolean isSpherical = Provider.isSpherical(parameters);
            ParameterDescriptorGroup descriptor = this.getParameters();
            if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                if (isSpherical) {
                    return new PolarStereographic.Spherical(parameters, descriptor, null);
                }
                return new PolarStereographic(parameters, descriptor, null);
            }
            if (latitudeOfOrigin < 1.0E-6) {
                if (isSpherical) {
                    return new EquatorialStereographic.Spherical(parameters, descriptor);
                }
                return this.createMathTransform(parameters, descriptor);
            }
            if (isSpherical) {
                return new StereographicUSGS.Spherical(parameters, descriptor);
            }
            return this.createMathTransform(parameters, descriptor);
        }

        MathTransform createMathTransform(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
            return new StereographicUSGS(parameters, descriptor);
        }
    }
}

