/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.util.logging.Logging;
import org.geotools.xml.DocumentFactory;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.gml.FCFlowHandler;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.xml.sax.SAXException;

public class FCBuffer
extends Thread
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    public static final int FINISH = -1;
    public static final int STOP = -2;
    protected static Logger logger = FCBuffer.getLogger();
    protected int state = 0;
    private SimpleFeature[] features;
    private int end;
    private int size;
    private int head;
    private int timeout = 1000;
    private URI document;
    protected SAXException exception = null;
    protected SimpleFeatureType ft = null;
    private volatile Date lastUpdate;

    private FCBuffer() {
        super("Feature Collection Buffer");
    }

    protected FCBuffer(URI document, int capacity, int timeout, SimpleFeatureType ft) {
        super("Feature Collection Buffer");
        this.features = new SimpleFeature[capacity];
        this.timeout = timeout;
        this.document = document;
        this.head = 0;
        this.size = 0;
        this.end = 0;
        this.ft = ft;
    }

    private static final Logger getLogger() {
        Logger l = Logging.getLogger(FCBuffer.class);
        l.setLevel(Level.WARNING);
        return l;
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.features.length;
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addFeature(SimpleFeature f) {
        if (this.ft == null) {
            this.ft = f.getFeatureType();
        }
        if (this.size >= this.features.length) {
            return false;
        }
        FCBuffer fCBuffer = this;
        synchronized (fCBuffer) {
            this.notify();
            this.features[this.end] = f;
            ++this.end;
            if (this.end == this.features.length) {
                this.end = 0;
            }
            ++this.size;
        }
        return true;
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(URI document, int capacity) throws SAXException {
        return FCBuffer.getFeatureReader(document, capacity, 1000, null);
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(URI document, int capacity, SimpleFeatureType ft) throws SAXException {
        return FCBuffer.getFeatureReader(document, capacity, 1000, ft);
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(URI document, int capacity, int timeout) throws SAXException {
        return FCBuffer.getFeatureReader(document, capacity, timeout, null);
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(URI document, int capacity, int timeout, SimpleFeatureType ft) throws SAXException {
        FCBuffer fc = new FCBuffer(document, capacity, timeout, ft);
        fc.start();
        if (fc.exception != null) {
            throw fc.exception;
        }
        return fc;
    }

    public SimpleFeatureType getFeatureType() {
        if (this.ft != null) {
            return this.ft;
        }
        Date d = new Date(Calendar.getInstance().getTimeInMillis() + (long)this.timeout);
        while (this.ft == null && this.state != -1 && this.state != -2) {
            FCBuffer.yield();
            if (!d.before(Calendar.getInstance().getTime())) continue;
            this.exception = new SAXException("Timeout");
            this.state = -2;
        }
        if (this.state == -1 || this.state == -2) {
            return this.ft;
        }
        return this.ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (this.exception != null) {
            this.state = -2;
            IOException e = new IOException(this.exception.toString());
            e.initCause(this.exception);
            throw e;
        }
        SimpleFeature f = null;
        FCBuffer fCBuffer = this;
        synchronized (fCBuffer) {
            --this.size;
            f = this.features[this.head++];
            this.notify();
            if (this.head == this.features.length) {
                this.head = 0;
            }
        }
        return f;
    }

    public SimpleFeature peek() throws IOException, NoSuchElementException {
        if (this.exception != null) {
            this.state = -2;
            IOException e = new IOException(this.exception.toString());
            e.initCause(this.exception);
            throw e;
        }
        SimpleFeature f = this.features[this.head];
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws IOException {
        Object e;
        if (this.exception instanceof StopException) {
            return false;
        }
        if (this.exception != null) {
            IOException e2 = new IOException(this.exception.toString());
            e2.initCause(this.exception);
            throw e2;
        }
        logger.finest("hasNext " + this.size);
        this.resetTimer();
        while (this.size <= 1 && this.state != -1 && this.state != -2) {
            if (this.exception != null) {
                this.state = -2;
                e = new IOException(this.exception.toString());
                ((Throwable)e).initCause(this.exception);
                throw e;
            }
            logger.finest("waiting for parser");
            try {
                e = this;
                synchronized (e) {
                    this.wait(200L);
                }
            }
            catch (InterruptedException e3) {
                // empty catch block
            }
            if (!this.lastUpdate.before(new Date(Calendar.getInstance().getTimeInMillis() - (long)this.timeout))) continue;
            this.exception = new SAXException("Timeout");
            this.state = -2;
        }
        if (this.state == -2) {
            if (this.exception != null) {
                e = new IOException(this.exception.toString());
                ((Throwable)e).initCause(this.exception);
                throw e;
            }
            return false;
        }
        if (this.state == -1) {
            return this.size != 0;
        }
        if (this.size == 0) {
            this.state = -2;
            if (this.exception != null) {
                throw new IOException(this.exception.toString());
            }
            throw new IOException("There was an error");
        }
        return true;
    }

    public void close() {
        this.state = -2;
        this.interrupt();
    }

    @Override
    public void run() {
        XMLHandlerHints hints = new XMLHandlerHints();
        this.initHints(hints);
        try {
            DocumentFactory.getInstance(this.document, hints);
        }
        catch (StopException e) {
            this.exception = e;
            this.state = -2;
            FCBuffer.yield();
        }
        catch (SAXException e) {
            this.exception = e;
            this.state = -2;
            FCBuffer.yield();
        }
    }

    protected void initHints(XMLHandlerHints hints) {
        hints.put("org.geotools.xml.gml.STREAM_HINT", (Object)this);
        hints.put("FLOW_HANDLER_HINT", (Object)new FCFlowHandler());
        if (this.ft != null) {
            hints.put("DEBUG_INFO_FEATURE_TYPE_NAME", (Object)this.ft.getTypeName());
        }
    }

    public int getInternalState() {
        return this.state;
    }

    public void resetTimer() {
        this.lastUpdate = Calendar.getInstance().getTime();
    }

    public static class StopException
    extends SAXException {
        public StopException() {
            super("Stopping");
        }
    }
}

