/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class DictAspect {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Autowired
    private CommonAPI commonAPI;
    @Autowired
    public RedisTemplate redisTemplate;

    @Pointcut(value="execution(public * org.jeecg.modules..*.*Controller.*(..))")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        long time1 = System.currentTimeMillis();
        Object result = pjp.proceed();
        long time2 = System.currentTimeMillis();
        log.debug("\u83b7\u53d6JSON\u6570\u636e \u8017\u65f6\uff1a" + (time2 - time1) + "ms");
        long start = System.currentTimeMillis();
        this.parseDictText(result);
        long end = System.currentTimeMillis();
        log.debug("\u6ce8\u5165\u5b57\u5178\u5230JSON\u6570\u636e  \u8017\u65f6" + (end - start) + "ms");
        return result;
    }

    private void parseDictText(Object result) {
        if (result instanceof Result && ((Result)result).getResult() instanceof IPage) {
            String value;
            ArrayList<JSONObject> items = new ArrayList<JSONObject>();
            ArrayList<Field> dictFieldList = new ArrayList<Field>();
            HashMap<String, List<String>> dataListMap = new HashMap<String, List<String>>();
            for (Object record : ((IPage)((Result)result).getResult()).getRecords()) {
                ObjectMapper mapper = new ObjectMapper();
                String json = "{}";
                try {
                    json = mapper.writeValueAsString(record);
                }
                catch (JsonProcessingException e) {
                    log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
                }
                JSONObject item = JSONObject.parseObject((String)json);
                for (Field field : oConvertUtils.getAllFields(record)) {
                    value = item.getString(field.getName());
                    if (oConvertUtils.isEmpty(value)) continue;
                    if (field.getAnnotation(Dict.class) != null) {
                        if (!dictFieldList.contains(field)) {
                            dictFieldList.add(field);
                        }
                        String code = field.getAnnotation(Dict.class).dicCode();
                        String text = field.getAnnotation(Dict.class).dicText();
                        String table = field.getAnnotation(Dict.class).dictTable();
                        String dictCode = code;
                        if (!StringUtils.isEmpty((Object)table)) {
                            dictCode = String.format("%s,%s,%s", table, text, code);
                        }
                        List dataList = dataListMap.computeIfAbsent(dictCode, k -> new ArrayList());
                        this.listAddAllDeduplicate(dataList, Arrays.asList(value.split(",")));
                    }
                    if (!field.getType().getName().equals("java.util.Date") || field.getAnnotation(JsonFormat.class) != null || item.get((Object)field.getName()) == null) continue;
                    SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    item.put(field.getName(), (Object)aDate.format(new Date((Long)item.get((Object)field.getName()))));
                }
                items.add(item);
            }
            Map<String, List<DictModel>> translText = this.translateAllDict(dataListMap);
            for (JSONObject record : items) {
                for (Field field : dictFieldList) {
                    List<DictModel> dictModels;
                    String code = field.getAnnotation(Dict.class).dicCode();
                    String text = field.getAnnotation(Dict.class).dicText();
                    String table = field.getAnnotation(Dict.class).dictTable();
                    String fieldDictCode = code;
                    if (!StringUtils.isEmpty((Object)table)) {
                        fieldDictCode = String.format("%s,%s,%s", table, text, code);
                    }
                    if (!oConvertUtils.isNotEmpty(value = record.getString(field.getName())) || (dictModels = translText.get(fieldDictCode)) == null || dictModels.size() == 0) continue;
                    String textValue = this.translDictText(dictModels, value);
                    log.debug(" \u5b57\u5178Val : " + textValue);
                    log.debug(" __\u7ffb\u8bd1\u5b57\u5178\u5b57\u6bb5__ " + field.getName() + "_dictText" + "\uff1a " + textValue);
                    log.debug(" ---- dictCode: " + fieldDictCode);
                    log.debug(" ---- value: " + value);
                    log.debug(" ----- text: " + textValue);
                    log.debug(" ---- dictModels: " + JSON.toJSONString(dictModels));
                    record.put(field.getName() + "_dictText", (Object)textValue);
                }
            }
            ((IPage)((Result)result).getResult()).setRecords(items);
        }
    }

    private void listAddAllDeduplicate(List<String> dataList, List<String> addList) {
        List filterList = addList.stream().filter(i -> !dataList.contains(i)).collect(Collectors.toList());
        dataList.addAll(filterList);
    }

    private Map<String, List<DictModel>> translateAllDict(Map<String, List<String>> dataListMap) {
        HashMap<String, List<DictModel>> translText = new HashMap<String, List<DictModel>>();
        ArrayList<String> needTranslData = new ArrayList<String>();
        for (String dictCode : dataListMap.keySet()) {
            List<String> dataList = dataListMap.get(dictCode);
            if (dataList.size() == 0) continue;
            ArrayList<String> needTranslDataTable = new ArrayList<String>();
            for (String s : dataList) {
                List list;
                String text;
                String keyString;
                String data = s.trim();
                if (data.length() == 0) continue;
                if (dictCode.contains(",")) {
                    keyString = String.format("sys:cache:dictTable::SimpleKey [%s,%s]", dictCode, data);
                    if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
                        try {
                            text = oConvertUtils.getString(this.redisTemplate.opsForValue().get((Object)keyString));
                            list = translText.computeIfAbsent(dictCode, k -> new ArrayList());
                            list.add(new DictModel(data, text));
                        }
                        catch (Exception e) {
                            log.warn(e.getMessage());
                        }
                        continue;
                    }
                    if (needTranslDataTable.contains(data)) continue;
                    needTranslDataTable.add(data);
                    continue;
                }
                keyString = String.format("sys:cache:dict::%s:%s", dictCode, data);
                if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
                    try {
                        text = oConvertUtils.getString(this.redisTemplate.opsForValue().get((Object)keyString));
                        list = translText.computeIfAbsent(dictCode, k -> new ArrayList());
                        list.add(new DictModel(data, text));
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                    continue;
                }
                if (needTranslData.contains(data)) continue;
                needTranslData.add(data);
            }
            if (needTranslDataTable.size() <= 0) continue;
            String[] arr = dictCode.split(",");
            String table = arr[0];
            String text = arr[1];
            String code = arr[2];
            String values = String.join((CharSequence)",", needTranslDataTable);
            log.info("translateDictFromTableByKeys.dictCode:" + dictCode);
            log.info("translateDictFromTableByKeys.values:" + values);
            List<DictModel> texts = this.commonAPI.translateDictFromTableByKeys(table, text, code, values);
            log.info("translateDictFromTableByKeys.result:" + texts);
            List list = translText.computeIfAbsent(dictCode, k -> new ArrayList());
            list.addAll(texts);
            for (DictModel dict : texts) {
                String redisKey = String.format("sys:cache:dictTable::SimpleKey [%s,%s]", dictCode, dict.getValue());
                try {
                    this.redisTemplate.opsForValue().set((Object)redisKey, (Object)dict.getText());
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (needTranslData.size() > 0) {
            List<String> dictCodeList = Arrays.asList(dataListMap.keySet().toArray(new String[0]));
            List filterDictCodes = dictCodeList.stream().filter(key -> !key.contains(",")).collect(Collectors.toList());
            String dictCodes = String.join((CharSequence)",", filterDictCodes);
            String values = String.join((CharSequence)",", needTranslData);
            log.info("translateManyDict.dictCodes:" + dictCodes);
            log.info("translateManyDict.values:" + values);
            Map<String, List<DictModel>> manyDict = this.commonAPI.translateManyDict(dictCodes, values);
            log.info("translateManyDict.result:" + manyDict);
            for (String dictCode : manyDict.keySet()) {
                List list = translText.computeIfAbsent(dictCode, k -> new ArrayList());
                List<DictModel> newList = manyDict.get(dictCode);
                list.addAll(newList);
                for (DictModel dict : newList) {
                    String redisKey = String.format("sys:cache:dict::%s:%s", dictCode, dict.getValue());
                    try {
                        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)dict.getText());
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return translText;
    }

    private String translDictText(List<DictModel> dictModels, String values) {
        String[] splitVal;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = splitVal = values.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String val;
            String dictText = val = stringArray[i];
            for (DictModel dict : dictModels) {
                if (!val.equals(dict.getValue())) continue;
                dictText = dict.getText();
                break;
            }
            result.add(dictText);
        }
        return String.join((CharSequence)",", result);
    }

    @Deprecated
    private String translateDictValue(String code, String text, String table, String key) {
        String[] keys;
        if (oConvertUtils.isEmpty(key)) {
            return null;
        }
        StringBuffer textValue = new StringBuffer();
        for (String k : keys = key.split(",")) {
            String keyString;
            String tmpValue = null;
            log.debug(" \u5b57\u5178 key : " + k);
            if (k.trim().length() == 0) continue;
            if (!StringUtils.isEmpty((Object)table)) {
                log.info("--DictAspect------dicTable=" + table + " ,dicText= " + text + " ,dicCode=" + code);
                keyString = String.format("sys:cache:dictTable::SimpleKey [%s,%s,%s,%s]", table, text, code, k.trim());
                if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
                    try {
                        tmpValue = oConvertUtils.getString(this.redisTemplate.opsForValue().get((Object)keyString));
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                } else {
                    tmpValue = this.commonAPI.translateDictFromTable(table, text, code, k.trim());
                }
            } else {
                keyString = String.format("sys:cache:dict::%s:%s", code, k.trim());
                if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
                    try {
                        tmpValue = oConvertUtils.getString(this.redisTemplate.opsForValue().get((Object)keyString));
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                } else {
                    tmpValue = this.commonAPI.translateDict(code, k.trim());
                }
            }
            if (tmpValue == null) continue;
            if (!"".equals(textValue.toString())) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }
}

