/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.sign.interceptor;

import com.alibaba.fastjson.JSON;
import java.io.PrintWriter;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.DateUtils;
import org.jeecg.config.sign.util.BodyReaderHttpServletRequestWrapper;
import org.jeecg.config.sign.util.HttpUtils;
import org.jeecg.config.sign.util.SignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class SignAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SignAuthInterceptor.class);
    private static final long MAX_EXPIRE = 300L;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("request URI = " + request.getRequestURI());
        BodyReaderHttpServletRequestWrapper requestWrapper = new BodyReaderHttpServletRequestWrapper(request);
        SortedMap<String, String> allParams = HttpUtils.getAllParams((HttpServletRequest)requestWrapper);
        String headerSign = request.getHeader("X-Sign");
        String timesTamp = request.getHeader("X-TIMESTAMP");
        try {
            DateUtils.parseDate(timesTamp, "yyyyMMddHHmmss");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u683c\u5f0f\u5fc5\u987b\u4e3a:yyyyMMddHHmmss");
        }
        Long clientTimestamp = Long.parseLong(timesTamp);
        if (DateUtils.getCurrentTimestamp() - clientTimestamp > 300L) {
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f");
        }
        boolean isSigned = SignUtil.verifySign(allParams, headerSign);
        if (isSigned) {
            log.debug("Sign \u7b7e\u540d\u901a\u8fc7\uff01Header Sign : {}", (Object)headerSign);
            return true;
        }
        log.error("request URI = " + request.getRequestURI());
        log.error("Sign \u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01Header Sign : {}", (Object)headerSign);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        Result<Object> result = Result.error("Sign\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01");
        out.print(JSON.toJSON(result));
        return false;
    }
}

