/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.weibo.dto.WeiBoMentionsDto;
import com.jeecg.weibo.dto.WeiboUserTimelineDto;
import com.jeecg.weibo.exception.BusinessException;
import com.jeecg.weibo.util.HttpUtil;
import com.jeecg.weibo.util.WeiboStatusesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiboStatusesApi {
    private static final Logger logger = LoggerFactory.getLogger(WeiboStatusesApi.class);
    private static final String user_timeline_url = "https://api.weibo.com/2/statuses/user_timeline.json?1=1";
    private static final String user_timeline_ids_url = "https://api.weibo.com/2/statuses/user_timeline/ids.json?1=1";
    private static final String count_url = "https://api.weibo.com/2/statuses/count.json?1=1";
    private static final String show_url = "https://api.weibo.com/2/statuses/show.json?1=1";
    private static final String mentions_url = "https://api.weibo.com/2/statuses/mentions.json?1=1";
    private static final String mentions_ids_url = "https://api.weibo.com/2/statuses/mentions/ids.json?1=1";

    public static JSONObject getUserTimeline(WeiboUserTimelineDto userTimeline) {
        JSONObject j = null;
        try {
            logger.info("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684\u53c2\u6570\u4e3a:" + userTimeline.toString());
            WeiboStatusesUtil.getUserTimelineParmValidate(userTimeline);
            String requestUrl = WeiboStatusesUtil.getUserTimelineUrl(user_timeline_url, userTimeline);
            logger.info("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONObject getUserTimelineIds(WeiboUserTimelineDto userTimeline) {
        JSONObject j = null;
        try {
            logger.info("\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684ID\u7684\u53c2\u6570\u4e3a:" + userTimeline.toString());
            WeiboStatusesUtil.getUserTimelineIdsParmValidate(userTimeline);
            String requestUrl = WeiboStatusesUtil.getUserTimelineUrl(user_timeline_ids_url, userTimeline);
            logger.info("\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684ID\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684ID\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5fae\u535a\u7684ID\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONArray getCount(String access_token, String ids) {
        JSONArray j = null;
        try {
            logger.info("\u6279\u91cf\u83b7\u53d6\u6307\u5b9a\u5fae\u535a\u7684\u8f6c\u53d1\u6570\u8bc4\u8bba\u6570\u7684\u53c2\u6570\u4e3a:access_token:" + access_token + "     \u5fae\u535aID:" + ids);
            WeiboStatusesUtil.getCountParmValidate(access_token, ids);
            String requestUrl = WeiboStatusesUtil.getCountUrl(count_url, access_token, ids);
            logger.info("\u6279\u91cf\u83b7\u53d6\u6307\u5b9a\u5fae\u535a\u7684\u8f6c\u53d1\u6570\u8bc4\u8bba\u6570\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequestArr(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u6279\u91cf\u83b7\u53d6\u6307\u5b9a\u5fae\u535a\u7684\u8f6c\u53d1\u6570\u8bc4\u8bba\u6570\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u6279\u91cf\u83b7\u53d6\u6307\u5b9a\u5fae\u535a\u7684\u8f6c\u53d1\u6570\u8bc4\u8bba\u6570\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONObject getShow(String access_token, String id) {
        JSONObject j = null;
        try {
            logger.info("\u6839\u636eID\u83b7\u53d6\u5355\u6761\u5fae\u535a\u4fe1\u606f\u7684\u53c2\u6570\u4e3a:access_token:" + access_token + "     \u5fae\u535aID:" + id);
            WeiboStatusesUtil.getShowParmValidate(access_token, id);
            String requestUrl = WeiboStatusesUtil.getShowUrl(show_url, access_token, id);
            logger.info("\u6839\u636eID\u83b7\u53d6\u5355\u6761\u5fae\u535a\u4fe1\u606f\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u6839\u636eID\u83b7\u53d6\u5355\u6761\u5fae\u535a\u4fe1\u606f\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u6839\u636eID\u83b7\u53d6\u5355\u6761\u5fae\u535a\u4fe1\u606f\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONObject getMentions(WeiBoMentionsDto mentions) {
        JSONObject j = null;
        try {
            logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u7684\u53c2\u6570\u4e3a:" + mentions.toString());
            WeiboStatusesUtil.getMentionsParmValidate(mentions);
            String requestUrl = WeiboStatusesUtil.getMentionsUrl(mentions_url, mentions);
            logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONObject getMentionsIds(WeiBoMentionsDto mentions) {
        JSONObject j = null;
        try {
            logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u7684ID\u7684\u53c2\u6570\u4e3a:" + mentions.toString());
            WeiboStatusesUtil.getMentionsParmValidate(mentions);
            String requestUrl = WeiboStatusesUtil.getMentionsUrl(mentions_ids_url, mentions);
            logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u7684ID\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u7684ID\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u83b7\u53d6@\u5f53\u524d\u7528\u6237\u7684\u6700\u65b0\u5fae\u535a\u7684ID\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static void main(String[] args) {
    }
}

