/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;

public class QRCode {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static void main(String[] args) {
        String filePostfix = "png";
        File file = new File("C://test_QR_CODE." + filePostfix);
        QRCode.encode("http://www.baidu.com", file, filePostfix, BarcodeFormat.QR_CODE, 500, 500, null);
        QRCode.decode(file);
    }

    public static void encode(String contents, File file, String filePostfix, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) {
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(contents, format, width, height);
            QRCode.writeToFile(bitMatrix, filePostfix, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
        BufferedImage image = QRCode.toBufferedImage(matrix);
        ImageIO.write((RenderedImage)image, format, file);
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static void decode(File file) {
        try {
            try {
                BufferedImage image = ImageIO.read(file);
                if (image == null) {
                    System.out.println("Could not decode image");
                }
                BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
                BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
                hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
                Result result = new MultiFormatReader().decode(bitmap, hints);
                String resultStr = result.getText();
                System.out.println("\u89e3\u6790\u540e\u5185\u5bb9\uff1a" + resultStr);
            }
            catch (IOException ioe) {
                System.out.println(ioe.toString());
            }
            catch (ReaderException re) {
                System.out.println(re.toString());
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

