/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression.operators.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class ExpressionList
implements ItemsList {
    private List<Expression> expressions;

    public ExpressionList() {
    }

    public ExpressionList(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public ExpressionList(Expression ... expressions) {
        this.expressions = Arrays.asList(expressions);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public ExpressionList addExpressions(Expression ... elements) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(list, elements);
        return this.withExpressions(list);
    }

    public ExpressionList withExpressions(List<Expression> expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public void accept(ItemsListVisitor itemsListVisitor) {
        itemsListVisitor.visit(this);
    }

    public String toString() {
        return PlainSelect.getStringList(this.expressions, true, true);
    }

    public ExpressionList addExpressions(Collection<? extends Expression> expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        collection.addAll(expressions);
        return this.withExpressions(collection);
    }
}

