/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;

public class WithItem
implements SelectBody {
    private String name;
    private List<SelectItem> withItemList;
    private SelectBody selectBody;
    private boolean recursive;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody selectBody) {
        this.selectBody = selectBody;
    }

    public List<SelectItem> getWithItemList() {
        return this.withItemList;
    }

    public void setWithItemList(List<SelectItem> withItemList) {
        this.withItemList = withItemList;
    }

    public String toString() {
        return (this.recursive ? "RECURSIVE " : "") + this.name + (this.withItemList != null ? " " + PlainSelect.getStringList(this.withItemList, true, true) : "") + " AS (" + this.selectBody + ")";
    }

    @Override
    public void accept(SelectVisitor visitor) {
        visitor.visit(this);
    }

    public WithItem withName(String name) {
        this.setName(name);
        return this;
    }

    public WithItem withWithItemList(List<SelectItem> withItemList) {
        this.setWithItemList(withItemList);
        return this;
    }

    public WithItem withSelectBody(SelectBody selectBody) {
        this.setSelectBody(selectBody);
        return this;
    }

    public WithItem withRecursive(boolean recursive) {
        this.setRecursive(recursive);
        return this;
    }

    public WithItem addWithItemList(SelectItem ... withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemList);
        return this.withWithItemList(collection);
    }

    public WithItem addWithItemList(Collection<? extends SelectItem> withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        collection.addAll(withItemList);
        return this.withWithItemList(collection);
    }

    public <E extends SelectBody> E getSelectBody(Class<E> type) {
        return (E)((SelectBody)type.cast(this.getSelectBody()));
    }
}

