/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.collection;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.collection.PdfCollectionSchema;
import com.itextpdf.kernel.pdf.collection.PdfCollectionSort;

public class PdfCollection
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 5184499156015360355L;
    public static final int DETAILS = 0;
    public static final int TILE = 1;
    public static final int HIDDEN = 2;

    public PdfCollection(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfCollection() {
        this(new PdfDictionary());
    }

    public PdfCollection setSchema(PdfCollectionSchema schema) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Schema, (PdfObject)schema.getPdfObject());
        return this;
    }

    public PdfCollectionSchema getSchema() {
        return new PdfCollectionSchema(((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Schema));
    }

    public PdfCollection setInitialDocument(String documentName) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.D, new PdfString(documentName));
        return this;
    }

    public PdfString getInitialDocument() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.D);
    }

    public PdfCollection setView(int viewType) {
        switch (viewType) {
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.View, PdfName.D);
                break;
            }
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.View, PdfName.T);
                break;
            }
            case 2: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.View, PdfName.H);
            }
        }
        return this;
    }

    @Deprecated
    public PdfNumber getView() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.View);
    }

    public boolean isViewDetails() {
        PdfName view = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.View);
        return view == null || view.equals(PdfName.D);
    }

    public boolean isViewTile() {
        return PdfName.T.equals(((PdfDictionary)this.getPdfObject()).getAsName(PdfName.View));
    }

    public boolean isViewHidden() {
        return PdfName.H.equals(((PdfDictionary)this.getPdfObject()).getAsName(PdfName.View));
    }

    public PdfCollection setSort(PdfCollectionSort sort) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Sort, (PdfObject)sort.getPdfObject());
        return this;
    }

    public PdfCollectionSort getSort() {
        return new PdfCollectionSort(((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Sort));
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

