/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.aop;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.annotation.Arguments;
import org.jeecgframework.minidao.annotation.ResultType;
import org.jeecgframework.minidao.annotation.Sql;
import org.jeecgframework.minidao.annotation.id.IdType;
import org.jeecgframework.minidao.annotation.id.TableId;
import org.jeecgframework.minidao.aspect.EmptyInterceptor;
import org.jeecgframework.minidao.pagehelper.dialect.PageAutoDialect;
import org.jeecgframework.minidao.pagehelper.parser.CountSqlParser;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.spring.rowMapper.MiniColumnMapRowMapper;
import org.jeecgframework.minidao.spring.rowMapper.MiniColumnOriginalMapRowMapper;
import org.jeecgframework.minidao.util.FreemarkerParseFactory;
import org.jeecgframework.minidao.util.MiniDaoUtil;
import org.jeecgframework.minidao.util.ParameterNameUtils;
import org.jeecgframework.minidao.util.ReflectUtil;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class MiniDaoHandler
implements InvocationHandler {
    private static final Log logger = LogFactory.getLog(MiniDaoHandler.class);
    @Autowired(required=false)
    @Qualifier(value="minidaoDataSource")
    public DataSource dataSource;
    @Autowired
    @Lazy
    private JdbcTemplate jdbcTemplate;
    @Autowired
    @Lazy
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    @Lazy
    private EmptyInterceptor emptyInterceptor;
    private ApplicationContext applicationContext;
    private String MUTL_DATASOURCES_MINIDAO_DF_DSNAME = "minidaoDataSource";
    private String UPPER_KEY = "upper";
    private String LOWER_KEY = "lower";
    private String keyType = "origin";
    private boolean formatSql = false;
    private boolean showSql = false;
    protected PageAutoDialect pageAutoDialect = new PageAutoDialect();
    protected CountSqlParser countSqlParser = new CountSqlParser();
    public static final String SEQ_NEXTVAL_SQL = "SELECT %s.nextval FROM DUAL";

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String executeSql;
        Object returnObj;
        block4: {
            returnObj = null;
            String templateSql = null;
            MiniDaoPage pageSetting = new MiniDaoPage();
            HashMap<String, Object> sqlParamsMap = new HashMap<String, Object>();
            templateSql = this.installDaoMetaData(pageSetting, method, sqlParamsMap, args);
            executeSql = this.parseSqlTemplate(method, templateSql, sqlParamsMap);
            if (executeSql == null || "".equals(executeSql)) {
                return null;
            }
            Map<String, Object> sqlMap = this.installPlaceholderSqlParam(executeSql, sqlParamsMap);
            this.initCheckDialectExists();
            try {
                returnObj = this.getReturnMinidaoResult(pageSetting, method, executeSql, sqlMap, args);
            }
            catch (Exception e) {
                returnObj = null;
                if (e instanceof EmptyResultDataAccessException) break block4;
                e.printStackTrace();
                throw e;
            }
        }
        if (this.showSql) {
            logger.info((Object)("Print MiniDao-Original-SQL :\n\n" + executeSql));
        }
        return returnObj;
    }

    private static boolean checkActiveKey(String methodName) {
        String[] keys;
        for (String s : keys = "insert,add,create,update,modify,store,delete,remove".split(",")) {
            if (!methodName.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkActiveSql(String sql) {
        String[] keys;
        sql = sql.trim().toLowerCase();
        for (String s : keys = "insert,add,create,update,modify,store,delete,remove".split(",")) {
            if (!sql.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkBatchKey(String methodName) {
        String[] keys;
        for (String s : keys = "batch".split(",")) {
            if (!methodName.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void addResulArray(int[] result, int index, int[] arr) {
        for (int result[index - length + i] : arr) {
        }
    }

    private int[] batchUpdate(String executeSql) {
        String[] sqls = executeSql.split(";");
        if (sqls.length < 100) {
            return this.jdbcTemplate.batchUpdate(sqls);
        }
        int[] result = new int[sqls.length];
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < sqls.length; ++i) {
            sqlList.add(sqls[i]);
            if (i % 100 != 0) continue;
            this.addResulArray(result, i + 1, this.jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
            sqlList.clear();
        }
        this.addResulArray(result, sqls.length, this.jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
        return result;
    }

    private RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        if (this.getKeyType().equalsIgnoreCase(this.LOWER_KEY)) {
            return new MiniColumnMapRowMapper();
        }
        if (this.getKeyType().equalsIgnoreCase(this.UPPER_KEY)) {
            return new ColumnMapRowMapper();
        }
        return new MiniColumnOriginalMapRowMapper();
    }

    public JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            try {
                this.namedParameterJdbcTemplate = (NamedParameterJdbcTemplate)this.applicationContext.getBean(NamedParameterJdbcTemplate.class);
                this.jdbcTemplate = (JdbcTemplate)this.applicationContext.getBean(JdbcTemplate.class);
            }
            catch (BeansException e) {
                logger.warn((Object)e.getMessage());
                Map multDataSourceMap = this.applicationContext.getBeansOfType(DataSource.class);
                if (multDataSourceMap != null) {
                    String keyOfTheFirst = (String)multDataSourceMap.entrySet().stream().filter(d -> ((String)d.getKey()).equals(this.MUTL_DATASOURCES_MINIDAO_DF_DSNAME)).findFirst().get().getKey();
                    this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((DataSource)multDataSourceMap.get(keyOfTheFirst));
                    this.jdbcTemplate = new JdbcTemplate((DataSource)multDataSourceMap.get(keyOfTheFirst));
                }
            }
        } else if (null != this.dataSource) {
            this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getReturnMinidaoResult(MiniDaoPage pageSetting, Method method, String executeSql, Map<String, Object> paramMap, Object[] args) {
        String methodName;
        block28: {
            if (this.namedParameterJdbcTemplate == null) {
                try {
                    this.namedParameterJdbcTemplate = (NamedParameterJdbcTemplate)this.applicationContext.getBean(NamedParameterJdbcTemplate.class);
                    this.jdbcTemplate = (JdbcTemplate)this.applicationContext.getBean(JdbcTemplate.class);
                }
                catch (BeansException e) {
                    logger.warn((Object)e.getMessage());
                    Map multDataSourceMap = this.applicationContext.getBeansOfType(DataSource.class);
                    if (multDataSourceMap != null) {
                        String keyOfTheFirst = (String)multDataSourceMap.entrySet().stream().filter(d -> ((String)d.getKey()).equals(this.MUTL_DATASOURCES_MINIDAO_DF_DSNAME)).findFirst().get().getKey();
                        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((DataSource)multDataSourceMap.get(keyOfTheFirst));
                        this.jdbcTemplate = new JdbcTemplate((DataSource)multDataSourceMap.get(keyOfTheFirst));
                    }
                    break block28;
                }
            }
            if (null != this.dataSource) {
                this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
                this.jdbcTemplate = new JdbcTemplate(this.dataSource);
            }
        }
        if (this.emptyInterceptor == null) {
            try {
                this.emptyInterceptor = (EmptyInterceptor)this.applicationContext.getBean(EmptyInterceptor.class);
            }
            catch (BeansException e) {
                logger.warn((Object)e.getMessage());
            }
        }
        if (MiniDaoHandler.checkActiveKey(methodName = method.getName()) || MiniDaoHandler.checkActiveSql(executeSql)) {
            List idFdList = null;
            Object obj = null;
            if (methodName.startsWith("insert") && args != null) {
                obj = args[0];
                Field[] fields = obj.getClass().getDeclaredFields();
                idFdList = Arrays.asList(fields).stream().filter(a -> a.getAnnotation(TableId.class) != null && a.getAnnotation(TableId.class).type() == IdType.AUTO).collect(Collectors.toList());
            }
            if (idFdList != null && idFdList.size() > 0) {
                GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
                if (paramMap != null) {
                    MapSqlParameterSource paramSource = new MapSqlParameterSource(paramMap);
                    this.namedParameterJdbcTemplate.update(executeSql, (SqlParameterSource)paramSource, (KeyHolder)keyHolder, new String[]{((Field)idFdList.get(0)).getName()});
                } else {
                    this.jdbcTemplate.update(executeSql, new Object[]{keyHolder});
                }
                HashMap<Object, Object> idVal = new HashMap<Object, Object>();
                idVal.put(((Field)idFdList.get(0)).getName(), keyHolder.getKey().intValue());
                try {
                    ReflectUtil.setFieldValue(idVal, obj);
                    return null;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    return null;
                }
            }
            if (paramMap == null) return this.jdbcTemplate.update(executeSql);
            return this.namedParameterJdbcTemplate.update(executeSql, paramMap);
        }
        if (MiniDaoHandler.checkBatchKey(methodName)) {
            return this.batchUpdate(executeSql);
        }
        Class<Object> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            Number number = (Number)this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, BigDecimal.class);
            if ("int".equals(returnType.getCanonicalName())) {
                return number.intValue();
            }
            if ("long".equals(returnType.getCanonicalName())) {
                return number.longValue();
            }
            if (!"double".equals(returnType.getCanonicalName())) return null;
            return number.doubleValue();
        }
        if (returnType.isAssignableFrom(List.class) || returnType.isAssignableFrom(MiniDaoPage.class)) {
            int page = pageSetting.getPage();
            int rows = pageSetting.getRows();
            if (page != 0 && rows != 0) {
                if (returnType.isAssignableFrom(MiniDaoPage.class)) {
                    String countsql;
                    if (paramMap != null) {
                        countsql = this.countSqlParser.getSmartCountSql(executeSql);
                        logger.info((Object)("page countsql===> " + countsql));
                        pageSetting.setTotal((Integer)this.namedParameterJdbcTemplate.queryForObject(countsql, paramMap, Integer.class));
                    } else {
                        countsql = this.countSqlParser.getSmartCountSql(executeSql);
                        logger.info((Object)("page countsql===> " + countsql));
                        pageSetting.setTotal((Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class));
                    }
                }
                if (this.pageAutoDialect.getDelegate() != null) {
                    executeSql = this.pageAutoDialect.getDelegate().getPageSql(executeSql, pageSetting);
                    logger.info((Object)("page executeSql===> " + executeSql));
                }
            }
            RowMapper<?> resultType = this.getListRealType(method);
            Class resultClassType = this.getListClassType(method);
            List list = paramMap != null ? (resultClassType.isAssignableFrom(String.class) || resultClassType.isAssignableFrom(Date.class) || resultClassType.isAssignableFrom(Integer.class) || resultClassType.isAssignableFrom(Double.class) || resultClassType.isAssignableFrom(Long.class) ? this.namedParameterJdbcTemplate.queryForList(executeSql, paramMap, resultClassType) : this.namedParameterJdbcTemplate.query(executeSql, paramMap, resultType)) : (resultClassType.isAssignableFrom(String.class) || resultClassType.isAssignableFrom(Date.class) || resultClassType.isAssignableFrom(Integer.class) || resultClassType.isAssignableFrom(Double.class) || resultClassType.isAssignableFrom(Long.class) ? this.jdbcTemplate.queryForList(executeSql, resultClassType) : this.jdbcTemplate.query(executeSql, resultType));
            if (!returnType.isAssignableFrom(MiniDaoPage.class)) return list;
            pageSetting.setResults(list);
            return pageSetting;
        }
        if (returnType.isAssignableFrom(Map.class)) {
            if (paramMap == null) return this.jdbcTemplate.queryForObject(executeSql, this.getColumnMapRowMapper());
            return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, this.getColumnMapRowMapper());
        }
        if (returnType.isAssignableFrom(String.class)) {
            if (paramMap == null) return this.jdbcTemplate.queryForObject(executeSql, String.class);
            return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, String.class);
        }
        if (MiniDaoUtil.isWrapClass(returnType)) {
            if (paramMap == null) return this.jdbcTemplate.queryForObject(executeSql, returnType);
            return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, returnType);
        }
        BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(returnType);
        if (paramMap == null) return this.jdbcTemplate.queryForObject(executeSql, (RowMapper)rm);
        return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, (RowMapper)rm);
    }

    private RowMapper<?> getListRealType(Method method) {
        ResultType resultType = method.getAnnotation(ResultType.class);
        if (resultType != null) {
            if (resultType.value().equals(Map.class)) {
                return this.getColumnMapRowMapper();
            }
            return BeanPropertyRowMapper.newInstance(resultType.value());
        }
        String genericReturnType = method.getGenericReturnType().toString();
        String realType = genericReturnType.replace("java.util.List", "").replace("<", "").replace(">", "");
        if (realType.contains("java.util.Map")) {
            return this.getColumnMapRowMapper();
        }
        if (realType.length() > 0) {
            try {
                return BeanPropertyRowMapper.newInstance(Class.forName(realType));
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), e.fillInStackTrace());
                throw new RuntimeException("minidao get class error ,class name is:" + realType);
            }
        }
        return this.getColumnMapRowMapper();
    }

    private Class getListClassType(Method method) {
        ResultType resultType = method.getAnnotation(ResultType.class);
        if (resultType != null) {
            if (resultType.value().equals(Map.class)) {
                return Map.class;
            }
            return resultType.value();
        }
        String genericReturnType = method.getGenericReturnType().toString();
        String realType = genericReturnType.replace("java.util.List", "").replace("<", "").replace(">", "");
        if (realType.contains("java.util.Map")) {
            return Map.class;
        }
        if (realType.length() > 0) {
            try {
                return Class.forName(realType);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), e.fillInStackTrace());
                throw new RuntimeException("minidao get class error ,class name is:" + realType);
            }
        }
        return null;
    }

    private String installDaoMetaData(MiniDaoPage pageSetting, Method method, Map<String, Object> sqlParamsMap, Object[] args) throws Exception {
        Field[] fields;
        Object obj;
        String methodName;
        if (this.emptyInterceptor != null && args != null && args.length == 1) {
            methodName = method.getName();
            obj = args[0];
            if (obj != null) {
                fields = obj.getClass().getDeclaredFields();
                if (methodName.startsWith("insert") && this.emptyInterceptor != null) {
                    this.emptyInterceptor.onInsert(fields, obj);
                }
                if (methodName.startsWith("update") && this.emptyInterceptor != null) {
                    this.emptyInterceptor.onUpdate(fields, obj);
                }
            }
        }
        if ((methodName = method.getName()).startsWith("insert") && args != null) {
            obj = args[0];
            fields = obj.getClass().getDeclaredFields();
            this.initIdAnnotation(fields, obj);
        }
        String templateSql = null;
        boolean arguments_flag = method.isAnnotationPresent(Arguments.class);
        if (arguments_flag) {
            Arguments arguments = method.getAnnotation(Arguments.class);
            logger.debug((Object)("@Arguments------------------------------------------" + Arrays.toString(arguments.value())));
            if (arguments.value().length != args.length) {
                throw new Exception("\u6ce8\u91ca\u6807\u7b7e@Arguments\u53c2\u6570\u6570\u76ee\uff0c\u4e0e\u65b9\u6cd5\u53c2\u6570\u6570\u76ee\u4e0d\u76f8\u7b49~");
            }
            int args_num = 0;
            for (String v : arguments.value()) {
                if (v.equalsIgnoreCase("page")) {
                    pageSetting.setPage(Integer.parseInt(args[args_num].toString()));
                }
                if (v.equalsIgnoreCase("rows")) {
                    pageSetting.setRows(Integer.parseInt(args[args_num].toString()));
                }
                sqlParamsMap.put(v, args[args_num]);
                ++args_num;
            }
        } else if (args != null && args.length >= 1) {
            String[] params = ParameterNameUtils.getMethodParameterNamesByAnnotation(method);
            if (params == null || params.length == 0) {
                throw new Exception("\u65b9\u6cd5\u53c2\u6570\u6570\u76ee>=2\uff0c\u5fc5\u987b\u4f7f\u7528\uff1a\u65b9\u6cd5\u6807\u7b7e@Arguments \u6216  \u53c2\u6570\u6807\u7b7e@param");
            }
            if (params.length != args.length) {
                throw new Exception("\u65b9\u6cd5\u53c2\u6570\u6570\u76ee>=2\uff0c\u53c2\u6570\u5fc5\u987b\u4f7f\u7528\uff1a\u6807\u7b7e@param");
            }
            int args_num = 0;
            for (String v : params) {
                if (v == null) {
                    throw new Exception("Dao\u63a5\u53e3\u5b9a\u4e49\uff0c\u6240\u6709\u53c2\u6570\u5fc5\u987b\u4f7f\u7528@param\u6807\u7b7e~");
                }
                if (v.equalsIgnoreCase("page")) {
                    pageSetting.setPage(Integer.parseInt(args[args_num].toString()));
                }
                if (v.equalsIgnoreCase("rows")) {
                    pageSetting.setRows(Integer.parseInt(args[args_num].toString()));
                }
                sqlParamsMap.put(v, args[args_num]);
                ++args_num;
            }
        } else if (args != null && args.length == 1) {
            sqlParamsMap.put("dto", args[0]);
        }
        if (method.isAnnotationPresent(Sql.class)) {
            Sql sql = method.getAnnotation(Sql.class);
            if (StringUtils.isNotEmpty((CharSequence)sql.value())) {
                templateSql = sql.value();
            }
            logger.debug((Object)("@Sql------------------------------------------" + sql.value()));
        }
        return templateSql;
    }

    private void initIdAnnotation(Field[] fields, Object obj) throws Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int j = 0; j < fields.length; ++j) {
            String fieldName = fields[j].getName();
            TableId annotation = fields[j].getAnnotation(TableId.class);
            if (annotation == null) continue;
            IdType type = annotation.type();
            Object value = null;
            for (IdType idType : IdType.values()) {
                if (type == IdType.AUTO) break;
                if (type == IdType.ID_WORKER) {
                    value = SnowflakeIdWorker.generateId();
                    map.put(fieldName, value);
                    break;
                }
                if (type == IdType.UUID) {
                    value = UUID.randomUUID().toString().replace("-", "");
                    map.put(fieldName, value);
                    break;
                }
                if (type != IdType.ID_SEQ) continue;
                String seqName = annotation.seqName();
                if (StringUtils.isBlank((CharSequence)seqName)) {
                    throw new Exception("ID_SEQ\u6ce8\u89e3\u5b9a\u4e49\uff0c\u53c2\u6570\u5fc5\u987b\u914d\u7f6e\u5e8f\u5217\u540d");
                }
                value = this.jdbcTemplate.queryForObject(String.format(SEQ_NEXTVAL_SQL, seqName), Object.class);
                map.put(fieldName, value);
                break;
            }
            try {
                ReflectUtil.setFieldValue(map, obj);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, Object> installPlaceholderSqlParam(String executeSql, Map sqlParamsMap) throws OgnlException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String regEx = ":[ tnx0Bfr]*[0-9a-z.A-Z_]+";
        Pattern pat = Pattern.compile(regEx);
        Matcher m = pat.matcher(executeSql);
        while (m.find()) {
            logger.debug((Object)(" Match [" + m.group() + "] at positions " + m.start() + "-" + (m.end() - 1)));
            String ognl_key = m.group().replace(":", "").trim();
            logger.debug((Object)(" --- minidao --- \u89e3\u6790\u53c2\u6570 --- " + ognl_key));
            map.put(ognl_key, Ognl.getValue((String)ognl_key, (Object)sqlParamsMap));
        }
        return map;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    private String parseSqlTemplate(Method method, String templateSql, Map<String, Object> sqlParamsMap) throws Exception {
        String executeSql = null;
        if (StringUtils.isNotEmpty((CharSequence)templateSql)) {
            executeSql = FreemarkerParseFactory.parseTemplateContent(templateSql, sqlParamsMap);
        } else {
            String sqlTempletPath = method.getDeclaringClass().getName().replace(".", "/").replace("/dao/", "/sql/") + "_" + method.getName() + ".sql";
            if (!FreemarkerParseFactory.isExistTemplate(sqlTempletPath)) {
                sqlTempletPath = method.getDeclaringClass().getName().replace(".", "/") + "_" + method.getName() + ".sql";
            }
            logger.debug((Object)("MiniDao-SQL-Path:" + sqlTempletPath));
            executeSql = FreemarkerParseFactory.parseTemplate(sqlTempletPath, sqlParamsMap);
        }
        return executeSql;
    }

    public List<Object> procedureParamsList(Method method, Object[] args) throws Exception {
        ArrayList<Object> procedureParamsList = new ArrayList();
        boolean arguments_flag = method.isAnnotationPresent(Arguments.class);
        if (arguments_flag) {
            Arguments arguments = method.getAnnotation(Arguments.class);
            logger.debug((Object)("@Arguments------------------------------------------" + Arrays.toString(arguments.value())));
            if (arguments.value().length > args.length) {
                throw new Exception("[\u6ce8\u91ca\u6807\u7b7e]\u53c2\u6570\u6570\u76ee\uff0c\u4e0d\u80fd\u5927\u4e8e[\u65b9\u6cd5\u53c2\u6570]\u53c2\u6570\u6570\u76ee");
            }
            for (int i = 0; i < arguments.value().length; ++i) {
                procedureParamsList.add(args[i]);
            }
        } else {
            procedureParamsList = Arrays.asList(args);
        }
        return procedureParamsList;
    }

    private void initCheckDialectExists() {
        DataSource dataSource = this.getJdbcTemplate().getDataSource();
        this.pageAutoDialect.initDelegateDialect(dataSource);
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public EmptyInterceptor getEmptyInterceptor() {
        return this.emptyInterceptor;
    }

    public void setEmptyInterceptor(EmptyInterceptor emptyInterceptor) {
        this.emptyInterceptor = emptyInterceptor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

