/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.handler.sharding.ShardingNode;
import com.baomidou.mybatisplus.extension.plugins.handler.sharding.ShardingNodeExtractor;
import com.baomidou.mybatisplus.extension.plugins.handler.sharding.ShardingProcessor;
import com.baomidou.mybatisplus.extension.plugins.handler.sharding.ShardingStrategy;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.BatchExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ReuseExecutor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;

public class ShardingInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private final Map<String, ShardingStrategyProcessor> shardingMap;

    public ShardingInnerInterceptor(ShardingStrategy ... shardingStrategies) {
        this.shardingMap = Arrays.stream(shardingStrategies).collect(Collectors.toMap(ShardingStrategy::getLogicTable, i -> new ShardingStrategyProcessor((ShardingStrategy)i, (ShardingProcessor)ClassUtils.newInstance(i.getProcessor()))));
    }

    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        Executor executor = mpSh.executor();
        if (executor instanceof BatchExecutor || executor instanceof ReuseExecutor) {
            return;
        }
        this.doParse(mpSh);
    }

    @Override
    public void beforeGetBoundSql(StatementHandler sh) {
        this.doParse(PluginUtils.mpStatementHandler((StatementHandler)sh));
    }

    private void doParse(PluginUtils.MPStatementHandler mpSh) {
        if (InterceptorIgnoreHelper.willIgnoreSharding((String)mpSh.mappedStatement().getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
        mpBs.sql(this.parserMulti(mpBs.sql(), mpSh));
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object obj) {
        this.process((Statement)select, (PluginUtils.MPStatementHandler)obj);
    }

    @Override
    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        this.process((Statement)insert, (PluginUtils.MPStatementHandler)obj);
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        this.process((Statement)update, (PluginUtils.MPStatementHandler)obj);
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        this.process((Statement)delete, (PluginUtils.MPStatementHandler)obj);
    }

    private void process(Statement statement, PluginUtils.MPStatementHandler mpSh) {
        ShardingNodeExtractor shardingNodeExtractor = new ShardingNodeExtractor(statement);
        if (CollectionUtils.isEmpty(shardingNodeExtractor.getNodes())) {
            return;
        }
        List<Object> parameterValues = this.handleParameter(mpSh);
        for (ShardingNode<Table, ShardingNode<String, Integer>> tableNode : shardingNodeExtractor.getNodes()) {
            ShardingStrategyProcessor strategyProcessor = this.shardingMap.get(tableNode.getNode().getName());
            if (null == strategyProcessor) continue;
            HashMap<String, List<Object>> shardingValues = new HashMap<String, List<Object>>(tableNode.getList().size());
            for (ShardingNode<String, Integer> columnNode : tableNode.getList()) {
                if (CollectionUtils.isEmpty(columnNode.getList()) || !strategyProcessor.getStrategy().containsColumn(columnNode.getNode())) continue;
                shardingValues.put(columnNode.getNode(), columnNode.getList().stream().map(i -> parameterValues.get(i - 1)).collect(Collectors.toList()));
            }
            if (CollectionUtils.isEmpty(shardingValues)) {
                throw ExceptionUtils.mpe((String)"no fragment sharding column found", (Object[])new Object[0]);
            }
            tableNode.getNode().setName(strategyProcessor.getProcessor().doSharding(strategyProcessor.getStrategy(), shardingValues));
        }
    }

    private List<Object> handleParameter(PluginUtils.MPStatementHandler mpSh) {
        ArrayList<Object> values = new ArrayList<Object>();
        Object parameterObject = mpSh.boundSql().getParameterObject();
        List parameterMappings = mpSh.boundSql().getParameterMappings();
        if (parameterMappings != null) {
            for (ParameterMapping parameterMapping : parameterMappings) {
                Object value;
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (mpSh.boundSql().hasAdditionalParameter(propertyName)) {
                    value = mpSh.boundSql().getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (mpSh.configuration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = mpSh.configuration().newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                values.add(value);
            }
        }
        return values;
    }

    static class ShardingStrategyProcessor {
        private final ShardingStrategy strategy;
        private final ShardingProcessor processor;

        public ShardingStrategyProcessor(ShardingStrategy strategy, ShardingProcessor processor) {
            this.strategy = strategy;
            this.processor = processor;
        }

        public ShardingStrategy getStrategy() {
            return this.strategy;
        }

        public ShardingProcessor getProcessor() {
            return this.processor;
        }
    }
}

