/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.VendorExtension;

public abstract class SecurityScheme {
    private final String name;
    private final String type;
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();

    protected SecurityScheme(String name, String type) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<VendorExtension> getVendorExtensions() {
        return Collections.unmodifiableList(this.vendorExtensions);
    }

    protected void addValidVendorExtensions(List<VendorExtension> vendorExtensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(vendorExtensions).stream().filter(input -> input.getName().toLowerCase().startsWith("x-")).collect(Collectors.toList()));
    }
}

