/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.util.function.Predicate;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spring.web.plugins.Docket;

public class ApiSelectorBuilder {
    private final Docket parent;
    private Predicate<RequestHandler> requestHandlerSelector = ApiSelector.DEFAULT.getRequestHandlerSelector();
    private Predicate<String> pathSelector = ApiSelector.DEFAULT.getPathSelector();

    public ApiSelectorBuilder(Docket parent) {
        this.parent = parent;
    }

    public ApiSelectorBuilder apis(Predicate<RequestHandler> selector) {
        this.requestHandlerSelector = this.requestHandlerSelector.and(selector);
        return this;
    }

    public ApiSelectorBuilder paths(Predicate<String> selector) {
        this.pathSelector = this.pathSelector.and(selector);
        return this;
    }

    public Docket build() {
        return this.parent.selector(new ApiSelector(this.combine(this.requestHandlerSelector, this.pathSelector), this.pathSelector));
    }

    private Predicate<RequestHandler> combine(Predicate<RequestHandler> requestHandlerSelector, Predicate<String> pathSelector) {
        return requestHandlerSelector.and(this.transform(pathSelector));
    }

    private Predicate<RequestHandler> transform(final Predicate<String> pathSelector) {
        return new Predicate<RequestHandler>(){

            @Override
            public boolean test(RequestHandler input) {
                return input.getPatternsCondition().getPatterns().stream().anyMatch(pathSelector);
            }
        };
    }
}

