/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.OperationContext;

public class ExpansionContext {
    private final String parentName;
    private final ResolvedType paramType;
    private final OperationContext operationContext;
    private final Set<ResolvedType> seenTypes;

    public ExpansionContext(String parentName, ResolvedType paramType, OperationContext operationContext) {
        this(parentName, paramType, operationContext, new HashSet<ResolvedType>());
    }

    private ExpansionContext(String parentName, ResolvedType paramType, OperationContext operationContext, Set<ResolvedType> seenTypes) {
        this.parentName = parentName;
        this.paramType = paramType;
        this.operationContext = operationContext;
        this.seenTypes = new HashSet<ResolvedType>(seenTypes);
    }

    public String getParentName() {
        return this.parentName;
    }

    public ResolvedType getParamType() {
        return this.paramType;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public DocumentationContext getDocumentationContext() {
        return this.operationContext.getDocumentationContext();
    }

    public boolean hasSeenType(ResolvedType type) {
        return this.seenTypes.contains(type) || Objects.equals(type, this.paramType);
    }

    public ExpansionContext childContext(String parentName, ResolvedType childType, OperationContext operationContext) {
        HashSet<ResolvedType> childSeenTypes = new HashSet<ResolvedType>(this.seenTypes);
        childSeenTypes.add(childType);
        return new ExpansionContext(parentName, childType, operationContext, childSeenTypes);
    }
}

