/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArrayHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final float LOAD_FACTOR = 0.85f;
    private static final long serialVersionUID = 362498820763181265L;
    private MapEntry<K, V>[] entries;
    private int size;
    private int loadThreshold;

    static final int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    public ArrayHashMap() {
        this.clear();
    }

    private void setEntries(MapEntry[] entries) {
        this.entries = entries;
        this.loadThreshold = Math.round((float)this.entries.length * 0.85f);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        int index;
        MapEntry<K, V>[] table = this.entries;
        if (this.size == 0) {
            return false;
        }
        int hash = ArrayHashMap.hash(key);
        for (int i = index = hash & table.length - 1; i < table.length; ++i) {
            MapEntry<K, V> entry = table[i];
            if (entry == null) {
                return false;
            }
            if (entry.deleted) {
                if (entry.hash != hash || !entry.key.equals(key)) continue;
                return false;
            }
            if (entry.hash != hash || !entry.key.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index;
        MapEntry<K, V>[] table = this.entries;
        int hash = ArrayHashMap.hash(key);
        for (int i = index = hash & table.length - 1; i < table.length; ++i) {
            MapEntry<K, V> entry = table[i];
            if (entry == null) {
                return null;
            }
            if (entry.deleted) {
                if (entry.hash != hash || !entry.key.equals(key)) continue;
                return null;
            }
            if (entry.hash != hash || !entry.key.equals(key)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.setEntries(new MapEntry[8]);
    }

    @Override
    public V put(K key, V value) {
        int hash = ArrayHashMap.hash(key);
        MapEntry[] table = this.entries;
        while (true) {
            int index = hash & table.length - 1;
            MapEntry<K, V> tombstone = null;
            for (int i = index; i < table.length; ++i) {
                MapEntry<K, V> entry = table[i];
                if (entry != null && !entry.deleted) {
                    if (entry.hash != hash || !entry.key.equals(key)) continue;
                    return entry.setValue(value);
                }
                if (entry != null && entry.deleted) {
                    if (tombstone != null) continue;
                    tombstone = entry;
                    continue;
                }
                if (tombstone != null) {
                    ++this.size;
                    tombstone.key = key;
                    tombstone.hash = hash;
                    tombstone.deleted = false;
                    this.resizeIfLoadHigh(table);
                    return tombstone.setValue(value);
                }
                table[i] = entry = new MapEntry<K, V>(key, value, hash);
                ++this.size;
                this.resizeIfLoadHigh(table);
                return null;
            }
            table = this.resize(table);
            this.setEntries(table);
        }
    }

    private void resizeIfLoadHigh(MapEntry<K, V>[] table) {
        if (this.size >= this.loadThreshold) {
            this.setEntries(this.resize(table));
        }
    }

    private MapEntry<K, V>[] resize(MapEntry<K, V>[] table) {
        MapEntry[] newTable = new MapEntry[table.length * 2];
        for (int i = 0; i < table.length; ++i) {
            MapEntry<K, V> entry = table[i];
            if (entry == null || entry.deleted) continue;
            int hash = entry.hash;
            int index = hash & newTable.length - 1;
            boolean success = false;
            for (int j = index; j < newTable.length; ++j) {
                if (newTable[j] != null) continue;
                newTable[j] = entry;
                success = true;
                break;
            }
            assert (success);
        }
        return newTable;
    }

    @Override
    public V remove(Object key) {
        int index;
        MapEntry<K, V>[] table = this.entries;
        int hash = ArrayHashMap.hash(key);
        for (int i = index = hash & table.length - 1; i < table.length; ++i) {
            MapEntry<K, Object> entry = table[i];
            if (entry == null) {
                return null;
            }
            if (entry.deleted && entry.hash == hash && entry.key.equals(key)) {
                return null;
            }
            if (entry.hash != hash || !entry.key.equals(key)) continue;
            entry.deleted = true;
            entry.hash = 0;
            --this.size;
            return entry.setValue(null);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.entries.length; ++i) {
            MapEntry<K, V> entry = this.entries[i];
            if (entry == null || entry.deleted) continue;
            entrySet.add(entry);
        }
        return entrySet;
    }

    private static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        int hash;
        boolean deleted;

        public MapEntry(K key, V value, int hash) {
            this.key = key;
            this.value = value;
            this.hash = hash;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

