/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;

public class WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private CurvedGeometryFactory factory;
    private CoordinateSequenceFactory csFactory;
    private PrecisionModel precisionModel;
    private int inputDimension = 2;
    private int inputMeasures = 0;
    private boolean hasSRID = false;
    private boolean isStrict = false;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = WKBReader.hexToInt(hex.charAt(i2));
            int nib0 = WKBReader.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public WKBReader() {
        this(new GeometryFactory());
    }

    public WKBReader(GeometryFactory geometryFactory) {
        this.factory = this.getCurvedGeometryFactory(geometryFactory);
        this.precisionModel = this.factory.getPrecisionModel();
        this.csFactory = this.factory.getCoordinateSequenceFactory();
    }

    public Geometry read(byte[] bytes) throws ParseException {
        try {
            return this.read((InStream)new ByteArrayInStream(bytes));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
    }

    public Geometry read(InStream is) throws IOException, ParseException {
        this.dis.setInStream(is);
        Geometry g = this.readGeometry();
        return g;
    }

    protected Geometry readGeometry() throws IOException, ParseException {
        boolean hasM;
        byte byteOrderWKB = this.dis.readByte();
        int byteOrder = byteOrderWKB == 1 ? 2 : 1;
        this.dis.setOrder(byteOrder);
        int typeInt = this.dis.readInt();
        int geometryType = typeInt & 0xFF;
        boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0;
        this.inputDimension = hasZ ? 3 : 2;
        boolean bl = hasM = (typeInt & 0x40000000) != 0;
        if (hasM) {
            this.inputMeasures = 1;
            ++this.inputDimension;
        }
        this.hasSRID = (typeInt & 0x20000000) != 0;
        int SRID = 0;
        if (this.hasSRID) {
            SRID = this.dis.readInt();
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        Geometry geom = this.readGeometry(geometryType);
        this.setSRID(geom, SRID);
        return geom;
    }

    protected Geometry readGeometry(int geometryType) throws IOException, ParseException {
        Point geom = null;
        switch (geometryType) {
            case 1: {
                geom = this.readPoint();
                break;
            }
            case 2: {
                geom = this.readLineString();
                break;
            }
            case 3: {
                geom = this.readPolygon();
                break;
            }
            case 4: {
                geom = this.readMultiPoint();
                break;
            }
            case 5: 
            case 11: {
                geom = this.readMultiLineString();
                break;
            }
            case 6: 
            case 12: {
                geom = this.readMultiPolygon();
                break;
            }
            case 7: {
                geom = this.readGeometryCollection();
                break;
            }
            case 8: {
                geom = this.readCircularString();
                break;
            }
            case 9: {
                geom = this.readCompoundCurve();
                break;
            }
            case 10: {
                geom = this.readCurvePolygon();
                break;
            }
            default: {
                throw new ParseException("Unknown WKB type " + geometryType);
            }
        }
        return geom;
    }

    private Geometry setSRID(Geometry g, int SRID) {
        if (SRID != 0) {
            g.setSRID(SRID);
        }
        return g;
    }

    private Point readPoint() throws IOException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        return this.factory.createPoint(pts);
    }

    private LineString readLineString() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequenceLineString(size);
        return this.factory.createLineString(pts);
    }

    private Geometry readCircularString() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequenceCircularString(size);
        return this.factory.createCurvedGeometry(pts);
    }

    private Geometry readCompoundCurve() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        ArrayList<LineString> geoms = new ArrayList<LineString>();
        for (int i = 0; i < numGeom; ++i) {
            Geometry g = this.readGeometry();
            if (!(g instanceof LineString)) {
                throw new ParseException("Invalid geometry type encountered in CompoundCurve");
            }
            geoms.add((LineString)g);
        }
        return this.factory.createCurvedGeometry(geoms);
    }

    private LinearRing readLinearRing() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequenceRing(size);
        return this.factory.createLinearRing(pts);
    }

    protected Polygon readPolygon() throws IOException {
        int numRings = this.dis.readInt();
        LinearRing[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        LinearRing shell = this.readLinearRing();
        for (int i = 0; i < numRings - 1; ++i) {
            holes[i] = this.readLinearRing();
        }
        return this.factory.createPolygon(shell, holes);
    }

    protected Polygon readCurvePolygon() throws IOException, ParseException {
        int numRings = this.dis.readInt();
        LinearRing[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        LinearRing shell = this.readRing();
        for (int i = 0; i < numRings - 1; ++i) {
            holes[i] = this.readRing();
        }
        return this.factory.createPolygon(shell, holes);
    }

    private LinearRing readRing() throws IOException, ParseException {
        LineString ls = (LineString)this.readGeometry();
        if (!(ls instanceof LinearRing)) {
            if (!ls.isClosed()) {
                if (ls instanceof CompoundCurve) {
                    CompoundCurve cc = (CompoundCurve)ls;
                    List components = cc.getComponents();
                    Coordinate start = ((LineString)components.get(0)).getCoordinateN(0);
                    LineString lastGeom = (LineString)components.get(components.size() - 1);
                    Coordinate end = lastGeom.getCoordinateN(lastGeom.getNumPoints() - 1);
                    components.add(this.factory.createLineString(new Coordinate[]{start, end}));
                    ls = this.factory.createCurvedGeometry(components);
                } else {
                    Coordinate start = ls.getCoordinateN(0);
                    Coordinate end = ls.getCoordinateN(ls.getNumPoints() - 1);
                    LineString closer = this.factory.createLineString(new Coordinate[]{start, end});
                    ls = this.factory.createCurvedGeometry(new LineString[]{ls, closer});
                }
            } else if (ls instanceof CompoundCurve) {
                CompoundCurve cc = (CompoundCurve)ls;
                ls = new CompoundRing(cc.getComponents(), cc.getFactory(), cc.getTolerance());
            } else {
                ls = new LinearRing(ls.getCoordinateSequence(), ls.getFactory());
            }
        }
        return (LinearRing)ls;
    }

    private MultiPoint readMultiPoint() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Point[] geoms = new Point[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Point)) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            geoms[i] = (Point)g;
        }
        return this.factory.createMultiPoint(geoms);
    }

    private MultiLineString readMultiLineString() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        LineString[] geoms = new LineString[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g = this.readGeometry();
            if (!(g instanceof LineString)) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            geoms[i] = (LineString)g;
        }
        return this.factory.createMultiLineString(geoms);
    }

    private MultiPolygon readMultiPolygon() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Polygon[] geoms = new Polygon[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Polygon)) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            geoms[i] = (Polygon)g;
        }
        return this.factory.createMultiPolygon(geoms);
    }

    private GeometryCollection readGeometryCollection() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Geometry[] geoms = new Geometry[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            geoms[i] = this.readGeometry();
        }
        return this.factory.createGeometryCollection(geoms);
    }

    private CoordinateSequence readCoordinateSequence(int size) throws IOException {
        CoordinateSequence seq = JTS.createCS((CoordinateSequenceFactory)this.csFactory, (int)size, (int)this.inputDimension, (int)this.inputMeasures);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i = 0; i < size; ++i) {
            this.readCoordinate();
            for (int j = 0; j < targetDim; ++j) {
                seq.setOrdinate(i, j, this.ordValues[j]);
            }
        }
        return seq;
    }

    private CoordinateSequence readCoordinateSequenceCircularString(int size) throws IOException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        if (seq.size() == 0 || seq.size() >= 3) {
            return seq;
        }
        return CoordinateSequences.extend((CoordinateSequenceFactory)this.csFactory, (CoordinateSequence)seq, (int)3);
    }

    private CoordinateSequence readCoordinateSequenceLineString(int size) throws IOException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        if (seq.size() == 0 || seq.size() >= 2) {
            return seq;
        }
        return CoordinateSequences.extend((CoordinateSequenceFactory)this.csFactory, (CoordinateSequence)seq, (int)2);
    }

    private CoordinateSequence readCoordinateSequenceRing(int size) throws IOException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        if (CoordinateSequences.isRing((CoordinateSequence)seq)) {
            return seq;
        }
        return CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)this.csFactory, (CoordinateSequence)seq);
    }

    private void readCoordinate() throws IOException {
        for (int i = 0; i < this.inputDimension; ++i) {
            this.ordValues[i] = i <= 1 ? this.precisionModel.makePrecise(this.dis.readDouble()) : this.dis.readDouble();
        }
    }

    private CurvedGeometryFactory getCurvedGeometryFactory(GeometryFactory gf) {
        CurvedGeometryFactory curvedFactory = gf instanceof CurvedGeometryFactory ? (CurvedGeometryFactory)gf : new CurvedGeometryFactory(gf, Double.MAX_VALUE);
        return curvedFactory;
    }
}

