/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.sql.DataSource;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.factory.epsg.DirectEpsgFactory;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;
import org.geotools.referencing.factory.epsg.FactoryUsingSQL;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class ThreadedEpsgFactory
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    public static final String DATASOURCE_NAME = "java:comp/env/jdbc/EPSG";
    private static final boolean ALLOW_REGISTRATION = false;
    protected static final int PRIORITY = 90;
    private final ReferencingFactoryContainer factories;
    private transient InitialContext registerInto;
    private String datasourceName;
    protected DataSource datasource;
    protected boolean dynamicDataSource = true;

    public ThreadedEpsgFactory() {
        this((Hints)null);
    }

    public ThreadedEpsgFactory(Hints userHints) {
        this(userHints, 90);
    }

    public ThreadedEpsgFactory(Hints userHints, int priority) {
        super(userHints, priority);
        Object hint;
        Object object = hint = userHints == null ? null : userHints.get((Object)Hints.EPSG_DATA_SOURCE);
        if (hint == null) {
            this.datasourceName = DATASOURCE_NAME;
            this.hints.put(Hints.EPSG_DATA_SOURCE, this.datasourceName);
        } else if (hint instanceof String) {
            this.datasourceName = (String)hint;
            this.hints.put(Hints.EPSG_DATA_SOURCE, this.datasourceName);
        } else if (hint instanceof Attributes.Name) {
            Attributes.Name name = (Attributes.Name)hint;
            this.hints.put(Hints.EPSG_DATA_SOURCE, name);
            this.datasourceName = name.toString();
        } else if (hint instanceof DataSource) {
            this.datasource = (DataSource)hint;
            this.hints.put(Hints.EPSG_DATA_SOURCE, this.datasource);
            this.datasourceName = DATASOURCE_NAME;
            this.dynamicDataSource = false;
        }
        this.factories = ReferencingFactoryContainer.instance(userHints);
        long timeout = 1800000L;
        String defaultTimeout = System.getProperty("org.geotools.epsg.factory.timeout", String.valueOf(1800000));
        try {
            timeout = Long.valueOf(defaultTimeout);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Invalid value for org.geotools.epsg.factory.timeout, using the default (30 minutes) instead");
        }
        if (timeout > 0L) {
            LOGGER.log(Level.FINE, "Setting the EPSG factory " + ((Object)((Object)this)).getClass().getName() + " to a " + timeout + "ms timeout");
            this.setTimeout(timeout);
        } else {
            LOGGER.log(Level.FINE, "The EPSG factory " + ((Object)((Object)this)).getClass().getName() + " will not timeout");
        }
    }

    @Override
    public Citation getAuthority() {
        Citation authority = super.getAuthority();
        return authority != null ? authority : Citations.EPSG;
    }

    public final synchronized DataSource getDataSource() throws SQLException {
        if (this.datasource == null && !super.isAvailable()) {
            this.datasource = null;
            throw new SQLException(Errors.format((int)131));
        }
        return this.datasource;
    }

    public synchronized void setDataSource(DataSource datasource) throws SQLException {
        if (datasource != this.datasource) {
            try {
                this.dispose();
            }
            catch (FactoryException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                SQLException e = new SQLException(exception.getLocalizedMessage());
                e.initCause(exception);
                throw e;
            }
            this.datasource = datasource;
        }
    }

    protected DataSource createDataSource() throws SQLException {
        InitialContext context = null;
        DataSource source = null;
        try {
            context = GeoTools.getInitialContext((Hints)new Hints(this.hints));
            source = (DataSource)context.lookup(this.datasourceName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoInitialContextException noInitialContextException) {
        }
        catch (NamingException exception) {
            this.registerInto = context;
        }
        return source;
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        DataSource source = this.getDataSource();
        Connection connection = source.getConnection();
        String quote = connection.getMetaData().getIdentifierQuoteString();
        if (quote.equals("\"")) {
            return new FactoryUsingAnsiSQL(hints, connection);
        }
        return new FactoryUsingSQL(hints, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAuthorityFactory createBackingStore0() throws FactoryException, SQLException {
        AbstractAuthorityFactory factory;
        DataSource source;
        assert (Thread.holdsLock((Object)this));
        Hints sourceHints = new Hints(this.hints);
        sourceHints.putAll(this.factories.getImplementationHints());
        if (this.datasource != null) {
            return this.createBackingStore(sourceHints);
        }
        try {
            source = this.createDataSource();
            InitialContext context = this.registerInto;
        }
        finally {
            this.registerInto = null;
        }
        if (source == null) {
            throw new FactoryNotFoundException(Errors.format((int)131));
        }
        try {
            this.datasource = source;
            factory = this.createBackingStore(sourceHints);
        }
        finally {
            this.datasource = null;
        }
        this.datasource = source;
        return factory;
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        String product;
        String url = product = '<' + Vocabulary.format((int)252) + '>';
        try {
            factory = this.createBackingStore0();
            if (factory instanceof DirectEpsgFactory) {
                DatabaseMetaData info = ((DirectEpsgFactory)factory).getConnection().getMetaData();
                product = info.getDatabaseProductName();
                url = info.getURL();
            }
        }
        catch (SQLException exception) {
            throw new FactoryException(Errors.format((int)21, (Object)"EPSG"), (Throwable)exception);
        }
        ThreadedEpsgFactory.log(Loggings.format((Level)Level.CONFIG, (int)13, (Object)url, (Object)product));
        if (factory instanceof DirectEpsgFactory) {
            ((DirectEpsgFactory)factory).buffered = this;
        }
        return factory;
    }

    private static void log(LogRecord record) {
        record.setSourceClassName(ThreadedEpsgFactory.class.getName());
        record.setSourceMethodName("createBackingStore");
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    @Override
    protected boolean canDisposeBackingStore(AbstractAuthorityFactory backingStore) {
        if (backingStore instanceof DirectEpsgFactory) {
            return ((DirectEpsgFactory)backingStore).canDispose();
        }
        return super.canDisposeBackingStore(backingStore);
    }

    @Override
    protected void disposeBackingStore() {
        super.disposeBackingStore();
        if (this.dynamicDataSource) {
            this.datasource = null;
        }
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        super.dispose();
        this.datasource = null;
    }
}

