/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.FontCache;
import com.itextpdf.io.font.cmap.CMapCidByte;
import com.itextpdf.io.font.cmap.CMapCidUni;
import com.itextpdf.io.font.cmap.CMapLocationFromBytes;
import com.itextpdf.io.font.cmap.CMapParser;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.util.IntHashtable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.slf4j.LoggerFactory;

public class CMapEncoding
implements Serializable {
    private static final List<byte[]> IDENTITY_H_V_CODESPACE_RANGES = Arrays.asList({0, 0}, {-1, -1});
    private static final long serialVersionUID = 2418291066110642993L;
    private String cmap;
    private String uniMap;
    private boolean isDirect;
    private CMapCidUni cid2Uni;
    private CMapCidByte cid2Code;
    private IntHashtable code2Cid;
    private List<byte[]> codeSpaceRanges;

    public CMapEncoding(String cmap) {
        this.cmap = cmap;
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            this.isDirect = true;
        }
        this.codeSpaceRanges = IDENTITY_H_V_CODESPACE_RANGES;
    }

    public CMapEncoding(String cmap, String uniMap) {
        this.cmap = cmap;
        this.uniMap = uniMap;
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            this.cid2Uni = FontCache.getCid2UniCmap(uniMap);
            this.isDirect = true;
            this.codeSpaceRanges = IDENTITY_H_V_CODESPACE_RANGES;
        } else {
            this.cid2Code = FontCache.getCid2Byte(cmap);
            this.code2Cid = this.cid2Code.getReversMap();
            this.codeSpaceRanges = this.cid2Code.getCodeSpaceRanges();
        }
    }

    public CMapEncoding(String cmap, byte[] cmapBytes) {
        this.cmap = cmap;
        this.cid2Code = new CMapCidByte();
        try {
            CMapParser.parseCid(cmap, this.cid2Code, new CMapLocationFromBytes(cmapBytes));
            this.code2Cid = this.cid2Code.getReversMap();
            this.codeSpaceRanges = this.cid2Code.getCodeSpaceRanges();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Failed to parse encoding stream.");
        }
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public boolean hasUniMap() {
        return this.uniMap != null && this.uniMap.length() > 0;
    }

    public String getRegistry() {
        if (this.isDirect()) {
            return "Adobe";
        }
        return this.cid2Code.getRegistry();
    }

    public String getOrdering() {
        if (this.isDirect()) {
            return "Identity";
        }
        return this.cid2Code.getOrdering();
    }

    public int getSupplement() {
        if (this.isDirect()) {
            return 0;
        }
        return this.cid2Code.getSupplement();
    }

    public String getUniMapName() {
        return this.uniMap;
    }

    public String getCmapName() {
        return this.cmap;
    }

    @Deprecated
    public int getCmapCode(int cid) {
        if (this.isDirect) {
            return cid;
        }
        return CMapEncoding.toInteger(this.cid2Code.lookup(cid));
    }

    public byte[] getCmapBytes(int cid) {
        int length = this.getCmapBytesLength(cid);
        byte[] result = new byte[length];
        this.fillCmapBytes(cid, result, 0);
        return result;
    }

    public int fillCmapBytes(int cid, byte[] array, int offset) {
        if (this.isDirect) {
            array[offset++] = (byte)((cid & 0xFF00) >> 8);
            array[offset++] = (byte)(cid & 0xFF);
        } else {
            byte[] bytes = this.cid2Code.lookup(cid);
            for (int i = 0; i < bytes.length; ++i) {
                array[offset++] = bytes[i];
            }
        }
        return offset;
    }

    public void fillCmapBytes(int cid, ByteBuffer buffer) {
        if (this.isDirect) {
            buffer.append((byte)((cid & 0xFF00) >> 8));
            buffer.append((byte)(cid & 0xFF));
        } else {
            byte[] bytes = this.cid2Code.lookup(cid);
            buffer.append(bytes);
        }
    }

    public int getCmapBytesLength(int cid) {
        if (this.isDirect) {
            return 2;
        }
        return this.cid2Code.lookup(cid).length;
    }

    public int getCidCode(int cmapCode) {
        if (this.isDirect) {
            return cmapCode;
        }
        return this.code2Cid.get(cmapCode);
    }

    public boolean containsCodeInCodeSpaceRange(int code, int length) {
        for (int i = 0; i < this.codeSpaceRanges.size(); i += 2) {
            if (length != this.codeSpaceRanges.get(i).length) continue;
            int mask = 255;
            int totalShift = 0;
            byte[] low = this.codeSpaceRanges.get(i);
            byte[] high = this.codeSpaceRanges.get(i + 1);
            boolean fitsIntoRange = true;
            int ind = length - 1;
            while (ind >= 0) {
                int actualByteValue = (code & mask) >> totalShift;
                if (actualByteValue < (0xFF & low[ind]) || actualByteValue > (0xFF & high[ind])) {
                    fitsIntoRange = false;
                }
                --ind;
                totalShift += 8;
                mask <<= 8;
            }
            if (!fitsIntoRange) continue;
            return true;
        }
        return false;
    }

    private static int toInteger(byte[] bytes) {
        int result = 0;
        for (byte b : bytes) {
            result <<= 8;
            result += b & 0xFF;
        }
        return result;
    }
}

