/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.IOException;
import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.ByteUtils;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class OutputStream<T extends java.io.OutputStream>
extends java.io.OutputStream
implements Serializable {
    private static final long serialVersionUID = -5337390096148526418L;
    private final ByteBuffer numBuffer = new ByteBuffer(32);
    protected java.io.OutputStream outputStream = null;
    protected long currentPos = 0L;
    protected boolean closeStream = true;

    public static boolean getHighPrecision() {
        return ByteUtils.HighPrecision;
    }

    public static void setHighPrecision(boolean value) {
        ByteUtils.HighPrecision = value;
    }

    public OutputStream(java.io.OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected OutputStream() {
    }

    @Override
    public void write(int b) throws java.io.IOException {
        this.outputStream.write(b);
        ++this.currentPos;
    }

    @Override
    public void write(byte[] b) throws java.io.IOException {
        this.outputStream.write(b);
        this.currentPos += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws java.io.IOException {
        this.outputStream.write(b, off, len);
        this.currentPos += (long)len;
    }

    public void writeByte(byte value) {
        try {
            this.write(value);
        }
        catch (java.io.IOException e) {
            throw new IOException("Cannot write byte.", e);
        }
    }

    @Override
    public void flush() throws java.io.IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws java.io.IOException {
        if (this.closeStream) {
            this.outputStream.close();
        }
    }

    public T writeLong(long value) {
        try {
            ByteUtils.getIsoBytes(value, this.numBuffer.reset());
            this.write(this.numBuffer.getInternalBuffer(), this.numBuffer.capacity() - this.numBuffer.size(), this.numBuffer.size());
            return (T)this;
        }
        catch (java.io.IOException e) {
            throw new IOException("Cannot write int number.", e);
        }
    }

    public T writeInteger(int value) {
        try {
            ByteUtils.getIsoBytes(value, this.numBuffer.reset());
            this.write(this.numBuffer.getInternalBuffer(), this.numBuffer.capacity() - this.numBuffer.size(), this.numBuffer.size());
            return (T)this;
        }
        catch (java.io.IOException e) {
            throw new IOException("Cannot write int number.", e);
        }
    }

    public T writeFloat(float value) {
        return this.writeFloat(value, ByteUtils.HighPrecision);
    }

    public T writeFloat(float value, boolean highPrecision) {
        return this.writeDouble(value, highPrecision);
    }

    public T writeFloats(float[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.writeFloat(value[i]);
            if (i >= value.length - 1) continue;
            this.writeSpace();
        }
        return (T)this;
    }

    public T writeDouble(double value) {
        return this.writeDouble(value, ByteUtils.HighPrecision);
    }

    public T writeDouble(double value, boolean highPrecision) {
        try {
            ByteUtils.getIsoBytes(value, this.numBuffer.reset(), highPrecision);
            this.write(this.numBuffer.getInternalBuffer(), this.numBuffer.capacity() - this.numBuffer.size(), this.numBuffer.size());
            return (T)this;
        }
        catch (java.io.IOException e) {
            throw new IOException("Cannot write float number.", e);
        }
    }

    public T writeByte(int value) {
        try {
            this.write(value);
            return (T)this;
        }
        catch (java.io.IOException e) {
            throw new IOException("Cannot write byte.", e);
        }
    }

    public T writeSpace() {
        return this.writeByte(32);
    }

    public T writeNewLine() {
        return this.writeByte(10);
    }

    public T writeString(String value) {
        return this.writeBytes(ByteUtils.getIsoBytes(value));
    }

    public T writeBytes(byte[] b) {
        try {
            this.write(b);
            return (T)this;
        }
        catch (java.io.IOException e) {
            throw new IOException("Cannot write bytes.", e);
        }
    }

    public T writeBytes(byte[] b, int off, int len) {
        try {
            this.write(b, off, len);
            return (T)this;
        }
        catch (java.io.IOException e) {
            throw new IOException("Cannot write bytes.", e);
        }
    }

    public long getCurrentPos() {
        return this.currentPos;
    }

    public java.io.OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    public void assignBytes(byte[] bytes, int count) {
        if (!(this.outputStream instanceof ByteArrayOutputStream)) {
            throw new IOException("Bytes can be assigned to ByteArrayOutputStream only.");
        }
        ((ByteArrayOutputStream)this.outputStream).assignBytes(bytes, count);
        this.currentPos = count;
    }

    public void reset() {
        if (!(this.outputStream instanceof ByteArrayOutputStream)) {
            throw new IOException("Bytes can be reset in ByteArrayOutputStream only.");
        }
        ((ByteArrayOutputStream)this.outputStream).reset();
        this.currentPos = 0L;
    }

    private void readObject(ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws java.io.IOException {
        java.io.OutputStream tempOutputStream = this.outputStream;
        this.outputStream = null;
        out.defaultWriteObject();
        this.outputStream = tempOutputStream;
    }
}

