/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jeecg.common.util.MinioUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.filter.FileTypeFilter;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.common.util.oss.OssBootUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static Pattern ZHONGWEN_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");
    private static String DB_TYPE = "";
    private static DbType dbTypeEnum = null;

    public static String uploadOnlineImage(byte[] data, String basePath, String bizPath, String uploadType) {
        String dbPath = null;
        String fileName = "image" + Math.round(Math.random() * 1.0E11);
        fileName = fileName + "." + PoiPublicUtil.getFileExtendName((byte[])data);
        try {
            if ("local".equals(uploadType)) {
                File file = new File(basePath + File.separator + bizPath + File.separator);
                if (!file.exists()) {
                    file.mkdirs();
                }
                String savePath = file.getPath() + File.separator + fileName;
                File savefile = new File(savePath);
                FileCopyUtils.copy((byte[])data, (File)savefile);
                dbPath = bizPath + File.separator + fileName;
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                String relativePath = bizPath + "/" + fileName;
                if ("minio".equals(uploadType)) {
                    dbPath = MinioUtil.upload(in, relativePath);
                } else if ("alioss".equals(uploadType)) {
                    dbPath = OssBootUtil.upload(in, relativePath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbPath;
    }

    public static String getFileName(String fileName) {
        int pos;
        int unixSep = fileName.lastIndexOf(47);
        int winSep = fileName.lastIndexOf(92);
        int n = pos = winSep > unixSep ? winSep : unixSep;
        if (pos != -1) {
            fileName = fileName.substring(pos + 1);
        }
        fileName = fileName.replace("=", "").replace(",", "").replace("&", "").replace("#", "").replace("\u201c", "").replace("\u201d", "");
        fileName = fileName.replaceAll("\\s", "");
        return fileName;
    }

    public static boolean ifContainChinese(String str) {
        if (str.getBytes().length == str.length()) {
            return false;
        }
        Matcher m = ZHONGWEN_PATTERN.matcher(str);
        return m.find();
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType) {
        String url = "";
        url = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath) : OssBootUtil.upload(file, bizPath);
        return url;
    }

    public static String uploadLocal(MultipartFile mf, String bizPath, String uploadpath) {
        try {
            FileTypeFilter.fileTypeFilter(mf);
            String fileName = null;
            File file = new File(uploadpath + File.separator + bizPath + File.separator);
            if (!file.exists()) {
                file.mkdirs();
            }
            String orgName = mf.getOriginalFilename();
            fileName = (orgName = CommonUtils.getFileName(orgName)).indexOf(".") != -1 ? orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.lastIndexOf(".")) : orgName + "_" + System.currentTimeMillis();
            String savePath = file.getPath() + File.separator + fileName;
            File savefile = new File(savePath);
            FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            String dbpath = null;
            dbpath = oConvertUtils.isNotEmpty(bizPath) ? bizPath + File.separator + fileName : fileName;
            if (dbpath.contains("\\")) {
                dbpath = dbpath.replace("\\", "/");
            }
            return dbpath;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType, String customBucket) {
        String url = "";
        url = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath, customBucket) : OssBootUtil.upload(file, bizPath, customBucket);
        return url;
    }

    @Deprecated
    public static String getDatabaseType() {
        if (oConvertUtils.isNotEmpty(DB_TYPE)) {
            return DB_TYPE;
        }
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        try {
            return CommonUtils.getDatabaseTypeByDataSource(dataSource);
        }
        catch (SQLException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static DbType getDatabaseTypeEnum() {
        if (oConvertUtils.isNotEmpty(dbTypeEnum)) {
            return dbTypeEnum;
        }
        try {
            DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
            dbTypeEnum = JdbcUtils.getDbType((String)dataSource.getConnection().getMetaData().getURL());
            return dbTypeEnum;
        }
        catch (SQLException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDatabaseTypeByDataSource(DataSource dataSource) throws SQLException {
        if ("".equals(DB_TYPE)) {
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData md = connection.getMetaData();
                String dbType = md.getDatabaseProductName().toLowerCase();
                if (dbType.indexOf("mysql") >= 0) {
                    DB_TYPE = "MYSQL";
                } else if (dbType.indexOf("oracle") >= 0 || dbType.indexOf("dm") >= 0) {
                    DB_TYPE = "ORACLE";
                } else if (dbType.indexOf("sqlserver") >= 0 || dbType.indexOf("sql server") >= 0) {
                    DB_TYPE = "SQLSERVER";
                } else if (dbType.indexOf("postgresql") >= 0) {
                    DB_TYPE = "POSTGRESQL";
                } else if (dbType.indexOf("mariadb") >= 0) {
                    DB_TYPE = "MARIADB";
                } else {
                    log.error("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }
}

