/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.shiro;

import java.util.Set;
import javax.annotation.Resource;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.TenantContext;
import org.jeecg.config.shiro.JwtToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ShiroRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(ShiroRealm.class);
    @Lazy
    @Resource
    private CommonAPI commonAPI;
    @Lazy
    @Resource
    private RedisUtil redisUtil;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JwtToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        log.info("===============Shiro\u6743\u9650\u8ba4\u8bc1\u5f00\u59cb============ [ roles\u3001permissions]==========");
        String username = null;
        if (principals != null) {
            LoginUser sysUser = (LoginUser)principals.getPrimaryPrincipal();
            username = sysUser.getUsername();
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Set<String> roleSet = this.commonAPI.queryUserRoles(username);
        System.out.println(roleSet.toString());
        info.setRoles(roleSet);
        Set<String> permissionSet = this.commonAPI.queryUserAuths(username);
        info.addStringPermissions(permissionSet);
        System.out.println(permissionSet);
        log.info("===============Shiro\u6743\u9650\u8ba4\u8bc1\u6210\u529f==============");
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken auth) throws AuthenticationException {
        log.debug("===============Shiro\u8eab\u4efd\u8ba4\u8bc1\u5f00\u59cb============doGetAuthenticationInfo==========");
        String token = (String)auth.getCredentials();
        if (token == null) {
            log.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014IP\u5730\u5740:  " + oConvertUtils.getIpAddrByRequest(SpringContextUtils.getHttpServletRequest()));
            throw new AuthenticationException("token\u4e3a\u7a7a!");
        }
        LoginUser loginUser = this.checkUserTokenIsEffect(token);
        return new SimpleAuthenticationInfo((Object)loginUser, (Object)token, this.getName());
    }

    public LoginUser checkUserTokenIsEffect(String token) throws AuthenticationException {
        String contextTenantId;
        String username = JwtUtil.getUsername(token);
        if (username == null) {
            throw new AuthenticationException("token\u975e\u6cd5\u65e0\u6548!");
        }
        log.debug("\u2014\u2014\u2014\u6821\u9a8ctoken\u662f\u5426\u6709\u6548\u2014\u2014\u2014\u2014checkUserTokenIsEffect\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
        LoginUser loginUser = this.commonAPI.getUserByName(username);
        if (loginUser == null) {
            throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        if (loginUser.getStatus() != 1) {
            throw new AuthenticationException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (!this.jwtTokenRefresh(token, username, loginUser.getPassword())) {
            throw new AuthenticationException("Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!");
        }
        String userTenantIds = loginUser.getRelTenantIds();
        if (oConvertUtils.isNotEmpty(userTenantIds) && oConvertUtils.isNotEmpty(contextTenantId = TenantContext.getTenant()) && !"0".equals(contextTenantId) && String.join((CharSequence)",", userTenantIds).indexOf(contextTenantId) < 0) {
            throw new AuthenticationException("\u7528\u6237\u79df\u6237\u4fe1\u606f\u53d8\u66f4,\u8bf7\u91cd\u65b0\u767b\u9646!");
        }
        return loginUser;
    }

    public boolean jwtTokenRefresh(String token, String userName, String passWord) {
        String cacheToken = String.valueOf(this.redisUtil.get("prefix_user_token_" + token));
        if (oConvertUtils.isNotEmpty(cacheToken)) {
            if (!JwtUtil.verify(cacheToken, userName, passWord)) {
                String newAuthorization = JwtUtil.sign(userName, passWord);
                this.redisUtil.set("prefix_user_token_" + token, (Object)newAuthorization);
                this.redisUtil.expire("prefix_user_token_" + token, 3600L);
                log.debug("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u7528\u6237\u5728\u7ebf\u64cd\u4f5c\uff0c\u66f4\u65b0token\u4fdd\u8bc1\u4e0d\u6389\u7ebf\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014jwtTokenRefresh\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            }
            return true;
        }
        return false;
    }

    public void clearCache(PrincipalCollection principals) {
        super.clearCache(principals);
    }
}

