/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.hzz.axgh.yhdl.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.netty.util.internal.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.data.DataStore;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.modules.demo.hzz.axgh.yhdl.entity.RmYhdl;
import org.jeecg.modules.demo.hzz.axgh.yhdl.service.IRmYhdlService;
import org.jeecg.modules.demo.onemap.utils.Geotools;
import org.jeecg.modules.demo.onemap.utils.PGDatastore;
import org.jeecg.modules.demo.onemap.utils.Utility;
import org.jeecg.modules.demo.onemap.utils.ZipAndRarTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"rm_yhdl"})
@RestController
@RequestMapping(value={"/hzz.axgh.yhdl/rmYhdl"})
public class RmYhdlController
extends JeecgController<RmYhdl, IRmYhdlService> {
    private static final Logger log = LoggerFactory.getLogger(RmYhdlController.class);
    @Autowired
    private IRmYhdlService rmYhdlService;
    private Utility utility = new Utility();
    @Value(value="${jeecg.path.upload}")
    private String uploadpath;

    @AutoLog(value="rm_yhdl-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="rm_yhdl-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="rm_yhdl-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(RmYhdl rmYhdl, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rmYhdl, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.rmYhdlService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="rm_yhdl-\u6dfb\u52a0")
    @ApiOperation(value="rm_yhdl-\u6dfb\u52a0", notes="rm_yhdl-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody RmYhdl rmYhdl) throws Exception {
        this.rmYhdlService.save(rmYhdl);
        if (StringUtil.isNullOrEmpty((String)rmYhdl.getGeopath())) {
            return Result.OK((Object)"\u6dfb\u52a0\u6210\u529f\uff01\u77e2\u91cf\u6570\u636e\u672a\u4e0a\u4f20\uff01");
        }
        String msg = this.handleGeometry(rmYhdl.getId(), rmYhdl.getGeopath());
        return Result.OK((Object)("\u6dfb\u52a0\u6210\u529f\uff01" + msg));
    }

    private String handleGeometry(String id, String geoPath) {
        String warnMsg = "Shp\u89e3\u6790\u6210\u529f!";
        if (StringUtil.isNullOrEmpty((String)id) || StringUtil.isNullOrEmpty((String)geoPath)) {
            warnMsg = "\u53c2\u6570\u4e0d\u5168\uff0c\u65e0\u6cd5\u5904\u7406\uff01";
            return warnMsg;
        }
        String upFilePath = this.uploadpath + "/" + geoPath;
        String upFileName = upFilePath.substring(upFilePath.lastIndexOf("/") + 1);
        String fileNameNoExt = upFileName.substring(0, upFileName.lastIndexOf(46));
        String unZipPath = this.uploadpath + "/shpPath/" + fileNameNoExt;
        try {
            if (geoPath.endsWith(".zip")) {
                ZipAndRarTools.unZip(upFilePath, unZipPath);
            } else if (geoPath.endsWith(".rar")) {
                ZipAndRarTools.unrar(upFilePath, unZipPath);
            } else {
                return "\u77e2\u91cf\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01";
            }
            String shpfilepath = "";
            String prjFilePath = "";
            File file = new File(unZipPath);
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File shpFile = files[i];
                String fileName = shpFile.getName();
                if (fileName.endsWith(".shp")) {
                    shpfilepath = unZipPath + "/" + fileName;
                    continue;
                }
                if (!fileName.endsWith(".prj")) continue;
                prjFilePath = unZipPath + "/" + fileName;
            }
            PGDatastore pgDatastore = new PGDatastore();
            DataStore datastore = pgDatastore.getDefeaultDatastore();
            Geotools geotools = new Geotools(datastore);
            int prjType = 4490;
            if (StringUtil.isNullOrEmpty((String)prjFilePath)) {
                warnMsg = "\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u6ca1\u6709\u5750\u6807\u4fe1\u606f\uff08*.prj)\uff0c\u9ed8\u8ba4\u6309\u71672000\u5927\u5730\u5750\u6807\u5904\u7406\uff01";
            } else {
                String prjWkt = Geotools.getShpPrjWkt(prjFilePath);
                if (!prjWkt.contains("CGCS2000")) {
                    warnMsg = "\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u5750\u6807\u7cfb\u4e0d\u662f2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb\uff0c\u65e0\u6cd5\u5904\u7406\uff01";
                    return warnMsg;
                }
                if (prjWkt.startsWith("PROJCS")) {
                    prjType = prjWkt.contains("Zone_39") ? 4527 : (prjWkt.contains("CM_117E") ? 4548 : 4490);
                }
            }
            String shpWkt = Geotools.shp2wkt(shpfilepath);
            if (!StringUtil.isNullOrEmpty((String)shpWkt)) {
                if (shpWkt.startsWith("MULTILINESTRING")) {
                    shpWkt = shpWkt.replace("MULTILINESTRING", "LineString");
                    shpWkt = shpWkt.replace("((", "(");
                    shpWkt = shpWkt.replace("))", ")");
                }
                switch (prjType) {
                    case 4490: {
                        this.rmYhdlService.updYhdl3(shpWkt, id);
                        break;
                    }
                    case 4527: {
                        this.rmYhdlService.updYhdl2(shpWkt, id);
                        break;
                    }
                    case 4548: {
                        this.rmYhdlService.updYhdl(shpWkt, id);
                        break;
                    }
                }
            } else {
                warnMsg = "\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u6ca1\u6709\u89e3\u6790\u5230\u7a7a\u95f4\u56fe\u5f62\u4fe1\u606f\uff01";
                return warnMsg;
            }
            this.rmYhdlService.updGeoinfo(id);
        }
        catch (IOException e) {
            e.printStackTrace();
            warnMsg = e.getMessage();
            return warnMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            warnMsg = e.getMessage();
            return warnMsg;
        }
        return warnMsg;
    }

    @AutoLog(value="rm_yhdl-\u7f16\u8f91")
    @ApiOperation(value="rm_yhdl-\u7f16\u8f91", notes="rm_yhdl-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody RmYhdl rmYhdl) throws Exception {
        String newGeoPath;
        String id = rmYhdl.getId();
        RmYhdl oldRmYhdl = (RmYhdl)this.rmYhdlService.getById((Serializable)((Object)id));
        String oldGeoPath = oldRmYhdl.getGeopath();
        if (!oldGeoPath.equals(newGeoPath = rmYhdl.getGeopath())) {
            if (!StringUtil.isNullOrEmpty((String)oldGeoPath)) {
                this.delShpPath(oldGeoPath);
            } else {
                rmYhdl.setGeoinfo("");
                rmYhdl.setGeom(null);
            }
            if (StringUtil.isNullOrEmpty((String)newGeoPath)) {
                rmYhdl.setGeoinfo("");
                rmYhdl.setGeom(null);
            }
            this.rmYhdlService.updateById(rmYhdl);
            this.handleGeometry(id, newGeoPath);
        } else {
            this.rmYhdlService.updateById(rmYhdl);
        }
        return Result.OK((Object)"\u7f16\u8f91\u6210\u529f!");
    }

    private void delShpPath(String shpPath) {
        String upFilePath = this.uploadpath + "/" + shpPath;
        if (!StringUtil.isNullOrEmpty((String)upFilePath)) {
            File zipFile = new File(upFilePath);
            zipFile.delete();
        }
        String upFileName = upFilePath.substring(upFilePath.lastIndexOf("/") + 1);
        String fileNameNoExt = upFileName.substring(0, upFileName.lastIndexOf(46));
        String unZipPath = this.uploadpath + "/shpPath/" + fileNameNoExt;
        File oldGeoFolder = new File(unZipPath);
        Utility.deleteDir(oldGeoFolder);
    }

    @AutoLog(value="rm_yhdl-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="rm_yhdl-\u901a\u8fc7id\u5220\u9664", notes="rm_yhdl-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) throws Exception {
        RmYhdl rmYhdl = (RmYhdl)this.rmYhdlService.getById((Serializable)((Object)id));
        if (rmYhdl == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        String geoPath = rmYhdl.getGeopath();
        if (!StringUtil.isNullOrEmpty((String)geoPath)) {
            this.delShpPath(geoPath);
        }
        this.rmYhdlService.removeById((Serializable)((Object)id));
        return Result.OK((Object)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="rm_yhdl-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="rm_yhdl-\u6279\u91cf\u5220\u9664", notes="rm_yhdl-\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) throws Exception {
        List<String> yhdlList = Arrays.asList(ids.split(","));
        for (int i = 0; i < yhdlList.size(); ++i) {
            this.delete(yhdlList.get(i));
        }
        return Result.OK((Object)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="rm_yhdl-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="rm_yhdl-\u901a\u8fc7id\u67e5\u8be2", notes="rm_yhdl-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        RmYhdl rmYhdl = (RmYhdl)this.rmYhdlService.getById((Serializable)((Object)id));
        if (rmYhdl == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)rmYhdl);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, RmYhdl rmYhdl) {
        return super.exportXls(request, (Object)rmYhdl, RmYhdl.class, "rm_yhdl");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, RmYhdl.class);
    }

    @RequestMapping(value={"/importShapefile"}, method={RequestMethod.POST})
    public Result<?> importShapefile(HttpServletRequest request, HttpServletResponse response) {
        Result result = new Result();
        String warnMsg = null;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = multipartRequest.getFile("shp");
        String fileSavePath = this.uploadLocal(file, "hzz");
        if (!StringUtil.isNullOrEmpty((String)fileSavePath)) {
            try {
                String upFileName = fileSavePath.substring(fileSavePath.lastIndexOf("/") + 1);
                String fileNameNoExt = upFileName.substring(0, upFileName.lastIndexOf(46));
                String unZipPath = this.uploadpath + "/shpPath/" + fileNameNoExt;
                ZipAndRarTools.unZip(fileSavePath, unZipPath);
                String shpfilepath = "";
                String prjFilePath = "";
                File shpdir = new File(unZipPath);
                File[] files = shpdir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File shpFile = files[i];
                    String fileName = shpFile.getName();
                    if (fileName.endsWith(".shp")) {
                        shpfilepath = unZipPath + "/" + fileName;
                        continue;
                    }
                    if (!fileName.endsWith(".prj")) continue;
                    prjFilePath = unZipPath + "/" + fileName;
                }
                PGDatastore pgDatastore = new PGDatastore();
                DataStore datastore = pgDatastore.getDefeaultDatastore();
                Geotools geotools = new Geotools(datastore);
                int prjType = 4490;
                if (StringUtil.isNullOrEmpty((String)prjFilePath)) {
                    warnMsg = "\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u6ca1\u6709\u5750\u6807\u4fe1\u606f\uff08*.prj)\uff0c\u9ed8\u8ba4\u6309\u71672000\u5927\u5730\u5750\u6807\u5904\u7406\uff01";
                } else {
                    String prjWkt = Geotools.getShpPrjWkt(prjFilePath);
                    if (!prjWkt.contains("CGCS2000")) {
                        warnMsg = "\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u5750\u6807\u7cfb\u4e0d\u662f2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb\uff0c\u65e0\u6cd5\u5904\u7406\uff01";
                        result.setMessage(warnMsg);
                        result.setSuccess(false);
                        return result;
                    }
                    if (prjWkt.startsWith("PROJCS")) {
                        prjType = prjWkt.contains("Zone_39") ? 4527 : (prjWkt.contains("CM_117E") ? 4548 : 4490);
                    }
                }
                List<Map<String, Object>> featureList = Geotools.readShpFile(shpfilepath);
                if (featureList.size() == 0) {
                    result.setMessage("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u89e3\u6790\u5230\u6709\u6548\u8981\u7d20\uff01");
                    result.setSuccess(true);
                    return result;
                }
                for (int i = 0; i < featureList.size(); ++i) {
                    RmYhdl rmYhdl = new RmYhdl();
                    String wktStr = null;
                    Map<String, Object> feature = featureList.get(i);
                    for (String key : feature.keySet()) {
                        if ("the_geom".equals(key.toLowerCase())) {
                            wktStr = feature.get(key).toString();
                        }
                        if ("hlmc".equals(key.toLowerCase())) {
                            rmYhdl.setHlmc(feature.get(key).toString());
                        }
                        if ("hlbm".equals(key.toLowerCase())) {
                            rmYhdl.setHlbm(feature.get(key).toString());
                        }
                        if ("ab".equals(key.toLowerCase())) {
                            rmYhdl.setAb(feature.get(key).toString());
                        }
                        if ("dlmc".equals(key.toLowerCase())) {
                            rmYhdl.setDlmc(feature.get(key).toString());
                        }
                        if ("dljb".equals(key.toLowerCase())) {
                            rmYhdl.setDljb(feature.get(key).toString());
                        }
                        if ("dlcd".equals(key.toLowerCase())) {
                            rmYhdl.setDlcd(Double.parseDouble(feature.get(key).toString()));
                        }
                        if (!"dlkd".equals(key.toLowerCase())) continue;
                        rmYhdl.setDlkd(Double.parseDouble(feature.get(key).toString()));
                    }
                    this.rmYhdlService.save(rmYhdl);
                    String id = rmYhdl.getId();
                    if (!StringUtil.isNullOrEmpty(wktStr)) {
                        if (wktStr.startsWith("MULTILINESTRING")) {
                            wktStr = wktStr.replace("MULTILINESTRING", "LineString");
                            wktStr = wktStr.replace("((", "(");
                            wktStr = wktStr.replace("))", ")");
                        }
                        switch (prjType) {
                            case 4490: {
                                this.rmYhdlService.updYhdl3(wktStr, id);
                                break;
                            }
                            case 4527: {
                                this.rmYhdlService.updYhdl2(wktStr, id);
                                break;
                            }
                            case 4548: {
                                this.rmYhdlService.updYhdl(wktStr, id);
                                break;
                            }
                        }
                    }
                    this.rmYhdlService.updGeoinfo(id);
                }
                result.setMessage("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01");
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setMessage("\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                result.setSuccess(false);
                return result;
            }
        }
        return result;
    }

    private String uploadLocal(MultipartFile mf, String bizPath) {
        try {
            String ctxPath = this.uploadpath;
            String fileName = null;
            File file = new File(ctxPath + File.separator + bizPath + File.separator);
            if (!file.exists()) {
                file.mkdirs();
            }
            String orgName = mf.getOriginalFilename();
            fileName = (orgName = CommonUtils.getFileName((String)orgName)).indexOf(".") != -1 ? orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.lastIndexOf(".")) : orgName + "_" + System.currentTimeMillis();
            String savePath = file.getPath() + File.separator + fileName;
            File savefile = new File(savePath);
            FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            if (savePath.contains("\\")) {
                savePath = savePath.replace("\\", "/");
            }
            return savePath;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

