/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.hzz.hhhj.gsp.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.demo.hzz.hhhj.gsp.entity.RmBulletinBoard;
import org.jeecg.modules.demo.hzz.hhhj.gsp.geo.service.IRmGgpgeoService;
import org.jeecg.modules.demo.hzz.hhhj.gsp.service.IRmBulletinBoardService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u516c\u544a\u724c\u4fe1\u606f\u8868"})
@RestController
@RequestMapping(value={"/hzz.hhhj.gsp/rmBulletinBoard"})
public class RmBulletinBoardController
extends JeecgController<RmBulletinBoard, IRmBulletinBoardService> {
    private static final Logger log = LoggerFactory.getLogger(RmBulletinBoardController.class);
    @Autowired
    private IRmBulletinBoardService rmBulletinBoardService;
    @Autowired
    private IRmGgpgeoService rmGgpgeoService;

    @AutoLog(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(RmBulletinBoard rmBulletinBoard, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rmBulletinBoard, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.rmBulletinBoardService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u6dfb\u52a0", notes="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody RmBulletinBoard rmBulletinBoard) {
        this.rmBulletinBoardService.save(rmBulletinBoard);
        this.generateGeom(rmBulletinBoard);
        String geoinfo2 = this.rmGgpgeoService.getGeojson(rmBulletinBoard.getId());
        rmBulletinBoard.setGeoinfo(geoinfo2);
        rmBulletinBoard.setFlag(1);
        this.rmBulletinBoardService.saveOrUpdate(rmBulletinBoard);
        return Result.OK((Object)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    private void generateGeom(RmBulletinBoard rmBulletinBoard) {
        Double hzb = rmBulletinBoard.getHzb();
        Double zzb = rmBulletinBoard.getZzb();
        String id = rmBulletinBoard.getId();
        String gspbm = rmBulletinBoard.getGspbm();
        if (hzb > 3.9E7 || zzb > 3.9E7) {
            if (hzb > zzb) {
                this.rmGgpgeoService.addGsp2("POINT(" + hzb + " " + zzb + ")", id, gspbm);
            } else {
                this.rmGgpgeoService.addGsp2("POINT(" + zzb + " " + hzb + ")", id, gspbm);
            }
        } else if (hzb > 180.0 || zzb > 180.0) {
            if (hzb < zzb) {
                this.rmGgpgeoService.addGsp("POINT(" + hzb + " " + zzb + ")", id, gspbm);
            } else {
                this.rmGgpgeoService.addGsp("POINT(" + zzb + " " + hzb + ")", id, gspbm);
            }
        } else if (hzb > zzb) {
            this.rmGgpgeoService.addGsp3("POINT(" + hzb + " " + zzb + ")", id, gspbm);
        } else {
            this.rmGgpgeoService.addGsp3("POINT(" + zzb + " " + hzb + ")", id, gspbm);
        }
    }

    @AutoLog(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u7f16\u8f91", notes="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody RmBulletinBoard rmBulletinBoard) {
        this.rmBulletinBoardService.updateById(rmBulletinBoard);
        this.updateGeom(rmBulletinBoard);
        String geoinfo2 = this.rmGgpgeoService.getGeojson(rmBulletinBoard.getId());
        rmBulletinBoard.setGeoinfo(geoinfo2);
        this.rmBulletinBoardService.saveOrUpdate(rmBulletinBoard);
        return Result.OK((Object)"\u7f16\u8f91\u6210\u529f!");
    }

    private void updateGeom(RmBulletinBoard rmBulletinBoard) {
        Double hzb = rmBulletinBoard.getHzb();
        Double zzb = rmBulletinBoard.getZzb();
        String id = rmBulletinBoard.getId();
        String gspbm = rmBulletinBoard.getGspbm();
        if (hzb > 3.9E7 || zzb > 3.9E7) {
            if (hzb > zzb) {
                this.rmGgpgeoService.updGsp2("POINT(" + hzb + " " + zzb + ")", id, gspbm);
            } else {
                this.rmGgpgeoService.updGsp2("POINT(" + zzb + " " + hzb + ")", id, gspbm);
            }
        } else if (hzb > 180.0 || zzb > 180.0) {
            if (hzb < zzb) {
                this.rmGgpgeoService.updGsp("POINT(" + hzb + " " + zzb + ")", id, gspbm);
            } else {
                this.rmGgpgeoService.updGsp("POINT(" + zzb + " " + hzb + ")", id, gspbm);
            }
        } else if (hzb > zzb) {
            this.rmGgpgeoService.updGsp3("POINT(" + hzb + " " + zzb + ")", id, gspbm);
        } else {
            this.rmGgpgeoService.updGsp3("POINT(" + zzb + " " + hzb + ")", id, gspbm);
        }
    }

    @AutoLog(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.rmBulletinBoardService.removeById((Serializable)((Object)id));
        this.rmGgpgeoService.delGsp(id);
        return Result.OK((Object)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u6279\u91cf\u5220\u9664", notes="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.rmBulletinBoardService.removeByIds(Arrays.asList(ids.split(",")));
        List<String> gspIds = Arrays.asList(ids.split(","));
        for (int i = 0; i < gspIds.size(); ++i) {
            this.rmGgpgeoService.delGsp(gspIds.get(i));
        }
        return Result.OK((Object)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        RmBulletinBoard rmBulletinBoard = (RmBulletinBoard)this.rmBulletinBoardService.getById((Serializable)((Object)id));
        if (rmBulletinBoard == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)rmBulletinBoard);
    }

    @AutoLog(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7\u5173\u8054id\u67e5\u8be2")
    @ApiOperation(value="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7\u5173\u8054id\u67e5\u8be2", notes="\u516c\u544a\u724c\u4fe1\u606f\u8868-\u901a\u8fc7\u5173\u8054id\u67e5\u8be2")
    @GetMapping(value={"/queryByRelId"})
    public Result<?> queryByRelId(@RequestParam(name="relId", required=true) String relId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"gspbm", (Object)relId);
        RmBulletinBoard rmBulletinBoard = (RmBulletinBoard)this.rmBulletinBoardService.getOne((Wrapper)queryWrapper);
        if (rmBulletinBoard == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)rmBulletinBoard);
    }

    @AutoLog(value="\u751f\u6210\u516c\u544a\u724c\u7684\u56fe\u5f62")
    @ApiOperation(value="\u751f\u6210\u516c\u544a\u724c\u7684\u56fe\u5f62", notes="\u751f\u6210\u516c\u544a\u724c\u7684\u56fe\u5f62")
    @GetMapping(value={"/genarateGeo"})
    public Result<?> genarateGeo() {
        this.rmBulletinBoardService.GenarateGspGeo();
        return Result.OK((Object)"\u751f\u6210\u56fe\u5f62\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, RmBulletinBoard rmBulletinBoard) {
        return super.exportXls(request, (Object)rmBulletinBoard, RmBulletinBoard.class, "\u516c\u544a\u724c\u4fe1\u606f\u8868");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), RmBulletinBoard.class, (ImportParams)params);
                long start = System.currentTimeMillis();
                this.rmBulletinBoardService.saveBatch(list);
                for (RmBulletinBoard page : list) {
                    if (page.getHzb() != null && page.getZzb() != null) {
                        this.generateGeom(page);
                        String geoinfo2 = this.rmGgpgeoService.getGeojson(page.getId());
                        page.setGeoinfo(geoinfo2);
                        page.setFlag(1);
                    }
                    this.rmBulletinBoardService.saveOrUpdate(page);
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + list.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

