/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.hzz.shjsgc.dfgc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.netty.util.internal.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.data.DataStore;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.demo.hzz.shjsgc.dfgc.entity.RmDfgc;
import org.jeecg.modules.demo.hzz.shjsgc.dfgc.geo.service.IRmDfgcgeoService;
import org.jeecg.modules.demo.hzz.shjsgc.dfgc.service.IRmDfgcService;
import org.jeecg.modules.demo.onemap.utils.Geotools;
import org.jeecg.modules.demo.onemap.utils.PGDatastore;
import org.jeecg.modules.demo.onemap.utils.Utility;
import org.jeecg.modules.demo.onemap.utils.ZipAndRarTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5824\u9632\u5de5\u7a0b"})
@RestController
@RequestMapping(value={"/hzz.shjsgc.dfgc/rmDfgc"})
public class RmDfgcController
extends JeecgController<RmDfgc, IRmDfgcService> {
    private static final Logger log = LoggerFactory.getLogger(RmDfgcController.class);
    @Autowired
    private IRmDfgcService rmDfgcService;
    @Autowired
    private IRmDfgcgeoService rmDfgcgeoService;
    private Utility utility = new Utility();
    @Value(value="${jeecg.path.upload}")
    private String uploadpath;

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5824\u9632\u5de5\u7a0b-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(RmDfgc rmDfgc, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rmDfgc, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.rmDfgcService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u6dfb\u52a0")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u6dfb\u52a0", notes="\u5824\u9632\u5de5\u7a0b-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody RmDfgc rmDfgc) {
        this.rmDfgcService.save(rmDfgc);
        String id = UUID.randomUUID().toString().replace("-", "");
        String dfmc = rmDfgc.getDfmc();
        String gcjsqk = rmDfgc.getGcjsqk();
        String xmid = rmDfgc.getId();
        String dfgcgldwmc = rmDfgc.getDfgcgldwmc();
        String szhlmc = rmDfgc.getSzhlmc();
        String kgny = null;
        String jcny = null;
        if (rmDfgc.getKgny() != null && rmDfgc.getJcny() != null) {
            kgny = DateFormat.getDateInstance().format(rmDfgc.getKgny());
            jcny = DateFormat.getDateInstance().format(rmDfgc.getJcny());
        }
        String msg = "\u77e2\u91cf\u6570\u636e\u89e3\u6790\u6210\u529f\uff01";
        if (!StringUtil.isNullOrEmpty((String)rmDfgc.getGeopath())) {
            msg = this.handleGeometry(id, rmDfgc.getGeopath());
            rmDfgc.setFlag(1);
        }
        String geom = this.rmDfgcgeoService.getGeojson(id);
        rmDfgc.setGeoinfo(geom);
        this.rmDfgcService.saveOrUpdate(rmDfgc);
        this.rmDfgcService.insertshxm(id, dfmc, gcjsqk, xmid, "dfgc", dfgcgldwmc, kgny, jcny, szhlmc, geom);
        return Result.OK((Object)("\u6dfb\u52a0\u6210\u529f\uff01" + msg));
    }

    private String handleGeometry(String id, String geoPath) {
        String warnMsg;
        block21: {
            warnMsg = "\u77e2\u91cf\u6570\u636e\u89e3\u6790\u6210\u529f!";
            if (StringUtil.isNullOrEmpty((String)id) || StringUtil.isNullOrEmpty((String)geoPath)) {
                warnMsg = "\u53c2\u6570\u4e0d\u5168\uff0c\u65e0\u6cd5\u5904\u7406\uff01";
                return warnMsg;
            }
            String upFilePath = this.uploadpath + "/" + geoPath;
            String upFileName = upFilePath.substring(upFilePath.lastIndexOf("/") + 1);
            String fileNameNoExt = upFileName.substring(0, upFileName.lastIndexOf(46));
            String unZipPath = this.uploadpath + "/shpPath/" + fileNameNoExt;
            try {
                if (geoPath.endsWith(".zip")) {
                    ZipAndRarTools.unZip(upFilePath, unZipPath);
                } else if (geoPath.endsWith(".rar")) {
                    ZipAndRarTools.unrar(upFilePath, unZipPath);
                } else {
                    return "\u77e2\u91cf\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01";
                }
                String shpfilepath = "";
                String prjFilePath = "";
                File file = new File(unZipPath);
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File shpFile = files[i];
                    String fileName = shpFile.getName();
                    if (fileName.endsWith(".shp")) {
                        shpfilepath = unZipPath + "/" + fileName;
                        continue;
                    }
                    if (!fileName.endsWith(".prj")) continue;
                    prjFilePath = unZipPath + "/" + fileName;
                }
                PGDatastore pgDatastore = new PGDatastore();
                DataStore datastore = pgDatastore.getDefeaultDatastore();
                Geotools geotools = new Geotools(datastore);
                int prjType = 4490;
                if (StringUtil.isNullOrEmpty((String)prjFilePath)) {
                    warnMsg = "\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u6ca1\u6709\u5750\u6807\u4fe1\u606f\uff08*.prj)\uff0c\u9ed8\u8ba4\u6309\u71672000\u5927\u5730\u5750\u6807\u5904\u7406\uff01";
                } else {
                    String prjWkt = Geotools.getShpPrjWkt(prjFilePath);
                    if (!prjWkt.contains("CGCS2000")) {
                        warnMsg = "\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u5750\u6807\u7cfb\u4e0d\u662f2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb\uff0c\u65e0\u6cd5\u5904\u7406\uff01";
                        return warnMsg;
                    }
                    if (prjWkt.startsWith("PROJCS")) {
                        prjType = prjWkt.contains("Zone_39") ? 4527 : (prjWkt.contains("CM_117E") ? 4548 : 4490);
                    }
                }
                String shpWkt = Geotools.shp2wkt(shpfilepath);
                if (!StringUtil.isNullOrEmpty((String)shpWkt)) {
                    if (shpWkt.startsWith("LineString")) {
                        shpWkt = shpWkt.replace("LineString", "MULTILINESTRING");
                        shpWkt = shpWkt.replace("(", "((");
                        shpWkt = shpWkt.replace(")", "))");
                    }
                    switch (prjType) {
                        case 4490: {
                            this.rmDfgcgeoService.updDfgc3(shpWkt, id);
                            break;
                        }
                        case 4527: {
                            this.rmDfgcgeoService.updDfgc2(shpWkt, id);
                            break;
                        }
                        case 4548: {
                            this.rmDfgcgeoService.updDfgc(shpWkt, id);
                            break;
                        }
                    }
                    break block21;
                }
                warnMsg = "\u77e2\u91cf\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff1a\u4e0a\u4f20\u7684SHP\u6587\u4ef6\u6ca1\u6709\u89e3\u6790\u5230\u7a7a\u95f4\u56fe\u5f62\u4fe1\u606f\uff01";
                return warnMsg;
            }
            catch (IOException e) {
                e.printStackTrace();
                warnMsg = e.getMessage();
                return "\u77e2\u91cf\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff1a" + warnMsg;
            }
            catch (Exception e) {
                e.printStackTrace();
                warnMsg = e.getMessage();
                return "\u77e2\u91cf\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff1a" + warnMsg;
            }
        }
        return warnMsg;
    }

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u7f16\u8f91")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u7f16\u8f91", notes="\u5824\u9632\u5de5\u7a0b-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody RmDfgc rmDfgc) {
        String newGeoPath;
        RmDfgc oldDfgc;
        String oldGeoPath;
        String dfmc = rmDfgc.getDfmc();
        String gcjsqk = rmDfgc.getGcjsqk();
        String dfgcgldwmc = rmDfgc.getDfgcgldwmc();
        String id = rmDfgc.getId();
        String szhlmc = rmDfgc.getSzhlmc();
        String geoinfo2 = rmDfgc.getGeoinfo();
        String kgny = null;
        String jcny = null;
        if (rmDfgc.getKgny() != null && rmDfgc.getJcny() != null) {
            kgny = DateFormat.getDateInstance().format(rmDfgc.getKgny());
            jcny = DateFormat.getDateInstance().format(rmDfgc.getJcny());
        }
        if ((oldGeoPath = (oldDfgc = (RmDfgc)this.rmDfgcService.getById((Serializable)((Object)id))).getGeopath()) != (newGeoPath = rmDfgc.getGeopath())) {
            if (!StringUtil.isNullOrEmpty((String)oldGeoPath)) {
                this.delShpPath(oldGeoPath);
            } else {
                rmDfgc.setGeoinfo("");
            }
            if (StringUtil.isNullOrEmpty((String)newGeoPath)) {
                rmDfgc.setGeoinfo("");
            }
            this.rmDfgcService.updateById(rmDfgc);
            this.handleGeometry(id, newGeoPath);
            geoinfo2 = this.rmDfgcgeoService.getGeojson(id);
            rmDfgc.setGeoinfo(geoinfo2);
            this.rmDfgcService.saveOrUpdate(rmDfgc);
        } else {
            this.rmDfgcService.updateById(rmDfgc);
        }
        this.rmDfgcService.updateshxm(dfmc, gcjsqk, dfgcgldwmc, kgny, jcny, szhlmc, geoinfo2, id);
        return Result.OK((Object)"\u7f16\u8f91\u6210\u529f!");
    }

    private void delShpPath(String shpPath) {
        String upFilePath = this.uploadpath + "/" + shpPath;
        if (StringUtil.isNullOrEmpty((String)upFilePath)) {
            File zipFile = new File(upFilePath);
            zipFile.delete();
        }
        String upFileName = upFilePath.substring(upFilePath.lastIndexOf("/") + 1);
        String fileNameNoExt = upFileName.substring(0, upFileName.lastIndexOf(46));
        String unZipPath = this.uploadpath + "/shpPath/" + fileNameNoExt;
        File oldGeoFolder = new File(unZipPath);
        Utility.deleteDir(oldGeoFolder);
    }

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u5220\u9664", notes="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.rmDfgcService.deshxm(id);
        RmDfgc rmDfgc = (RmDfgc)this.rmDfgcService.getById((Serializable)((Object)id));
        if (rmDfgc == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        String geoPath = rmDfgc.getGeopath();
        if (!StringUtil.isNullOrEmpty((String)geoPath)) {
            this.delShpPath(geoPath);
        }
        this.rmDfgcService.removeById((Serializable)((Object)id));
        this.rmDfgcService.delete(id);
        return Result.OK((Object)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u6279\u91cf\u5220\u9664", notes="\u5824\u9632\u5de5\u7a0b-\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> dfidList = Arrays.asList(ids.split(","));
        for (int i = 0; i < dfidList.size(); ++i) {
            this.delete(dfidList.get(i));
        }
        return Result.OK((Object)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u67e5\u8be2", notes="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        RmDfgc rmDfgc = (RmDfgc)this.rmDfgcService.getById((Serializable)((Object)id));
        if (rmDfgc == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)rmDfgc);
    }

    @GetMapping(value={"/queryByIdInMap"})
    public Result<?> queryByIdInMap(RmDfgc rmDfgc, @RequestParam(name="id", required=true) String id, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rmDfgc, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"id", (Object)id);
        return Result.OK((Object)this.rmDfgcService.getOne((Wrapper)queryWrapper));
    }

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u67e5\u8be2Geometry")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u67e5\u8be2Geometry", notes="\u5824\u9632\u5de5\u7a0b-\u901a\u8fc7id\u67e5\u8be2Geometry")
    @GetMapping(value={"/getGeojsonById"})
    public Result<?> getGeojsonById(@RequestParam(name="id", required=true) String id) {
        String geom = this.rmDfgcgeoService.getGeojson(id);
        JSONObject geoJson = JSONObject.parseObject((String)geom);
        return Result.OK((Object)geoJson);
    }

    @AutoLog(value="")
    @ApiOperation(value="\u751f\u6210\u5824\u9632\u5de5\u7a0b\u7684\u56fe\u5f62", notes="\u751f\u6210\u5824\u9632\u5de5\u7a0b\u7684\u56fe\u5f62")
    @GetMapping(value={"/genarateGeo"})
    public Result<?> genarateGeo() {
        this.rmDfgcService.GenarateDfgcGeo();
        return Result.OK((Object)"\u751f\u6210\u56fe\u5f62\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, RmDfgc rmDfgc) {
        return super.exportXls(request, (Object)rmDfgc, RmDfgc.class, "\u5824\u9632\u5de5\u7a0b");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, RmDfgc.class);
    }

    @AutoLog(value="\u5824\u9632\u5de5\u7a0b-\u67e5\u8be2\u63d0\u9632\u957f\u5ea6")
    @ApiOperation(value="\u5824\u9632\u5de5\u7a0b-\u67e5\u8be2\u63d0\u9632\u957f\u5ea6", notes="\u5824\u9632\u5de5\u7a0b-\u67e5\u8be2\u63d0\u9632\u957f\u5ea6")
    @GetMapping(value={"/selectdfcd"})
    public Result<?> selectdfcd() {
        List<HashMap<String, String>> selectdfcd = this.rmDfgcService.selectdfcd();
        if (selectdfcd == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK(selectdfcd);
    }
}

