/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.mock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.IOUtils;
import org.jeecg.common.api.vo.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mock/api"})
public class MockController {
    private static final Logger log = LoggerFactory.getLogger(MockController.class);
    private final String JSON_PATH = "classpath:org/jeecg/modules/demo/mock/json";

    @RequestMapping(value={"/json/{filename}"}, method={RequestMethod.GET})
    public String getJsonData(@PathVariable String filename) {
        String jsonpath = "classpath:org/jeecg/modules/demo/mock/json/" + filename + ".json";
        return this.readJson(jsonpath);
    }

    @GetMapping(value={"/asynTreeList"})
    public String asynTreeList(String id) {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/asyn_tree_list_" + id + ".json");
    }

    @GetMapping(value={"/user"})
    public String user() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/user.json");
    }

    @GetMapping(value={"/user/info"})
    public String userInfo() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/user_info.json");
    }

    @GetMapping(value={"/role"})
    public String role() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/role.json");
    }

    @GetMapping(value={"/service"})
    public String service() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/service.json");
    }

    @GetMapping(value={"/permission"})
    public String permission() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/permission.json");
    }

    @GetMapping(value={"/permission/no-pager"})
    public String permission_no_page() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/permission_no_page.json");
    }

    @GetMapping(value={"/area"})
    public String area() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/area.json");
    }

    @GetMapping(value={"/report/getYearCountInfo"})
    public String getYearCountInfo() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/getCntrNoCountInfo.json");
    }

    @GetMapping(value={"/report/getMonthCountInfo"})
    public String getMonthCountInfo() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/getCntrNoCountInfo.json");
    }

    @GetMapping(value={"/report/getCntrNoCountInfo"})
    public String getCntrNoCountInfo() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/getCntrNoCountInfo.json");
    }

    @GetMapping(value={"/report/getCabinetCountInfo"})
    public String getCabinetCountInfo() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/getCntrNoCountInfo.json");
    }

    @GetMapping(value={"/report/getTubiao"})
    public String getTubiao() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/getTubiao.json");
    }

    @GetMapping(value={"/queryDiskInfo"})
    public Result<List<Map<String, Object>>> queryDiskInfo(HttpServletRequest request, HttpServletResponse response) {
        Result res = new Result();
        try {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            File[] fs = File.listRoots();
            log.info("\u67e5\u8be2\u78c1\u76d8\u4fe1\u606f:" + fs.length + "\u4e2a");
            ArrayList list = new ArrayList();
            for (int i = 0; i < fs.length; ++i) {
                if (fs[i].getTotalSpace() == 0L) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", fsv.getSystemDisplayName(fs[i]));
                map.put("max", fs[i].getTotalSpace());
                map.put("rest", fs[i].getFreeSpace());
                map.put("restPPT", fs[i].getFreeSpace() * 100L / fs[i].getTotalSpace());
                list.add(map);
                log.info(((Object)map).toString());
            }
            res.setResult(list);
            res.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            res.error500("\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return res;
    }

    @GetMapping(value={"/list/search/projects"})
    public String projects() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/workplace_projects.json");
    }

    @GetMapping(value={"/workplace/activity"})
    public String activity() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/workplace_activity.json");
    }

    @GetMapping(value={"/workplace/teams"})
    public String teams() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/workplace_teams.json");
    }

    @GetMapping(value={"/workplace/radar"})
    public String radar() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/workplace_radar.json");
    }

    @GetMapping(value={"/task/process"})
    public String taskProcess() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/task_process.json");
    }

    public String sysDataLogJson() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/sysdatalog.json");
    }

    @GetMapping(value={"/getUserInfo"})
    public String getUserInfo() {
        return this.readJson("classpath:org/jeecg/modules/demo/mock/json/userinfo.json");
    }

    private String readJson(String jsonSrc) {
        String json = "";
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(jsonSrc.replace("classpath:", ""));
            json = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return json;
    }
}

