/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.mock.vxe.websocket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/vxeSocket/{userId}/{pageId}")
public class VXESocket {
    private static final Logger log = LoggerFactory.getLogger(VXESocket.class);
    private Session session;
    private String userId;
    private String pageId;
    private String socketId;
    private static Map<String, Map<String, VXESocket>> userPool = new HashMap<String, Map<String, VXESocket>>();
    private static Map<String, VXESocket> socketPool = new HashMap<String, VXESocket>();

    public static Map<String, VXESocket> getUserPool(String userId) {
        return userPool.computeIfAbsent(userId, k -> new HashMap());
    }

    public void sendMessage(String message) {
        try {
            this.session.getAsyncRemote().sendText(message);
        }
        catch (Exception e) {
            log.error("\u3010vxeSocket\u3011\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static String packageMessage(String type, Object data) {
        JSONObject message = new JSONObject();
        message.put("type", (Object)type);
        message.put("data", data);
        return message.toJSONString();
    }

    public static void sendMessageTo(String userId, String message) {
        Collection<VXESocket> values = VXESocket.getUserPool(userId).values();
        if (values.size() > 0) {
            for (VXESocket socketItem : values) {
                socketItem.sendMessage(message);
            }
        } else {
            log.warn("\u3010vxeSocket\u3011\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1auserId\"" + userId + "\"\u4e0d\u5b58\u5728\u6216\u672a\u5728\u7ebf\uff01");
        }
    }

    public static void sendMessageTo(String userId, String pageId, String message) {
        VXESocket socketItem = VXESocket.getUserPool(userId).get(pageId);
        if (socketItem != null) {
            socketItem.sendMessage(message);
        } else {
            log.warn("\u3010vxeSocket\u3011\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1auserId\"" + userId + "\"\u7684pageId\"" + pageId + "\"\u4e0d\u5b58\u5728\u6216\u672a\u5728\u7ebf\uff01");
        }
    }

    public static void sendMessageTo(String[] userIds, String message) {
        for (String userId : userIds) {
            VXESocket.sendMessageTo(userId, message);
        }
    }

    public static void sendMessageToAll(String message) {
        for (VXESocket socketItem : socketPool.values()) {
            socketItem.sendMessage(message);
        }
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="userId") String userId, @PathParam(value="pageId") String pageId) {
        try {
            this.userId = userId;
            this.pageId = pageId;
            this.socketId = userId + pageId;
            this.session = session;
            socketPool.put(this.socketId, this);
            VXESocket.getUserPool(userId).put(this.pageId, this);
            log.info("\u3010vxeSocket\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + socketPool.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnClose
    public void onClose() {
        try {
            socketPool.remove(this.socketId);
            VXESocket.getUserPool(this.userId).remove(this.pageId);
            log.info("\u3010vxeSocket\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + socketPool.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnMessage
    public void onMessage(String message) {
        String type;
        JSONObject json;
        try {
            json = JSON.parseObject((String)message);
        }
        catch (Exception e) {
            log.warn("\u3010vxeSocket\u3011\u6536\u5230\u4e0d\u5408\u6cd5\u7684\u6d88\u606f:" + message);
            return;
        }
        switch (type = json.getString("type")) {
            case "heart_beat": {
                this.sendMessage(VXESocket.packageMessage(type, true));
                break;
            }
            case "update_vxe_table": {
                this.handleUpdateForm(json);
                break;
            }
            default: {
                log.warn("\u3010vxeSocket\u3011\u6536\u5230\u4e0d\u8bc6\u522b\u7684\u6d88\u606f\u7c7b\u578b:" + type);
            }
        }
    }

    private void handleUpdateForm(JSONObject json) {
        JSONObject data = json.getJSONObject("data");
        VXESocket.sendMessageToAll(VXESocket.packageMessage("update_vxe_table", data));
    }
}

