/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.onemap.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jeecg.modules.demo.onemap.utils.PGDatastore;
import org.jeecg.modules.demo.onemap.utils.ShpCharset;
import org.jeecg.modules.demo.onemap.utils.Utility;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Geotools {
    private static final Logger log = LoggerFactory.getLogger(Geotools.class);
    private static DataStore postgisDatasore;

    public Geotools(DataStore postgisDatasore) {
        if (postgisDatasore == null) {
            postgisDatasore = PGDatastore.getDefeaultDatastore();
        }
        Geotools.postgisDatasore = postgisDatasore;
    }

    public Geotools() {
        postgisDatasore = PGDatastore.getDefeaultDatastore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTxtFile(String path) {
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(path));
            inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader br = new BufferedReader(inputStreamReader);
            String s = null;
            while ((s = br.readLine()) != null) {
                stringBuilder.append(s);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String getShpPrjWkt(String prjFilePath) {
        String prjWkt = "";
        try {
            if (Utility.isEmpty(prjFilePath)) {
                log.error("\u89e3\u6790shp\u5750\u6807\u7cfb\u53c2\u6570\u65e0\u6548");
                return prjWkt;
            }
            prjWkt = Geotools.readTxtFile(prjFilePath);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790shp\u5750\u6807\u7cfb\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return prjWkt;
    }

    public static String shp2wkt(String shpPath) {
        String shpWkt = "";
        try {
            if (Utility.isEmpty(shpPath)) {
                log.error("\u89e3\u6790shp\u4e3awkt\u53c2\u6570\u65e0\u6548");
                return shpWkt;
            }
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(new File(shpPath).toURI().toURL());
            shapefileDataStore.setCharset(Charset.forName("Utf-8"));
            ContentFeatureCollection featureCollection = shapefileDataStore.getFeatureSource().getFeatures();
            FeatureIterator iterator = featureCollection.features();
            block2: while (iterator.hasNext()) {
                Feature feature = iterator.next();
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    if (!property.getName().toString().equals("the_geom")) continue;
                    shpWkt = property.getValue().toString();
                    System.out.println("@wkt:" + shpWkt);
                    continue block2;
                }
            }
            iterator.close();
        }
        catch (Exception e) {
            log.error("\u89e3\u6790shp\u4e3awkt\u5931\u8d25", (Throwable)e);
        }
        return shpWkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> readShpFile(String shapePath) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        ShapefileDataStore dataStore = null;
        try {
            dataStore = (ShapefileDataStore)factory.createDataStore(new File(shapePath).toURI().toURL());
            if (dataStore != null) {
                dataStore.setCharset(ShpCharset.GBK);
            }
            ContentFeatureSource featureSource = dataStore.getFeatureSource();
            SimpleFeatureIterator itertor = featureSource.getFeatures().features();
            while (itertor.hasNext()) {
                SimpleFeature feature = (SimpleFeature)itertor.next();
                Iterator itprop = feature.getProperties().iterator();
                HashMap<String, String> map = new HashMap<String, String>();
                while (itprop.hasNext()) {
                    Property prop = (Property)itprop.next();
                    map.put(String.valueOf(prop.getName()), String.valueOf(prop.getValue()));
                }
                list.add(map);
            }
            itertor.close();
        }
        catch (Exception e) {
            log.error("\u89e3\u6790shp\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        return list;
    }

    public static boolean write2pg(String id, FeatureCollection featureCollection, String pgtableName) {
        boolean result = false;
        try {
            if (Utility.isEmpty(featureCollection) || Utility.isEmpty(pgtableName)) {
                log.error("\u53c2\u6570\u65e0\u6548");
                return result;
            }
            SimpleFeatureType simpleFeatureType = (SimpleFeatureType)featureCollection.getSchema();
            System.out.println("simpleFeatureType:" + simpleFeatureType);
            FeatureIterator iterator = featureCollection.features();
            FeatureWriter featureWriter = postgisDatasore.getFeatureWriterAppend(pgtableName, Transaction.AUTO_COMMIT);
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                SimpleFeature simpleFeature = (SimpleFeature)featureWriter.next();
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    if (property.getName().toString().equals("the_geom")) {
                        simpleFeature.setAttribute("geom", property.getValue());
                        System.out.println(property.getValue());
                        continue;
                    }
                    if (property.getName().toString().equals("Id")) continue;
                    simpleFeature.setAttribute(property.getName().toString(), property.getValue());
                }
                System.out.println(simpleFeature);
                System.out.println(featureWriter);
                featureWriter.write();
            }
            iterator.close();
            featureWriter.close();
        }
        catch (Exception e) {
            log.error("\u5931\u8d25", (Throwable)e);
        }
        return false;
    }

    public static boolean write2shp(FeatureCollection featureCollection, ShapefileDataStore shpDataStore, String geomFieldName) {
        boolean result = false;
        if (Utility.isEmpty(geomFieldName)) {
            geomFieldName = featureCollection.getSchema().getGeometryDescriptor().getType().getName().toString();
        }
        try {
            FeatureIterator iterator = featureCollection.features();
            FeatureWriter featureWriter = shpDataStore.getFeatureWriter(shpDataStore.getTypeNames()[0], Transaction.AUTO_COMMIT);
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                SimpleFeature simpleFeature = (SimpleFeature)featureWriter.next();
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    if (property.getName().toString().equalsIgnoreCase(geomFieldName)) {
                        simpleFeature.setAttribute("the_geom", property.getValue());
                        continue;
                    }
                    simpleFeature.setAttribute(property.getName().toString(), property.getValue());
                }
                featureWriter.write();
            }
            iterator.close();
            featureWriter.close();
            shpDataStore.dispose();
        }
        catch (Exception e) {
            log.error("\u5931\u8d25", (Throwable)e);
        }
        return false;
    }

    public boolean geojson2shp(String geojsonPath, String shpfilepath) {
        return this.geojson2shp(geojsonPath, shpfilepath, ShpCharset.UTF_8);
    }

    public boolean geojson2shp(String geojsonPath, String shpfilepath, Charset shpChart) {
        boolean result = false;
        try {
            Utility.valiFileForRead(geojsonPath);
            FeatureJSON featureJSON = new FeatureJSON();
            featureJSON.setEncodeNullValues(true);
            FeatureCollection featureCollection = featureJSON.readFeatureCollection((Object)new InputStreamReader((InputStream)new FileInputStream(geojsonPath), "UTF-8"));
            File file = new File(shpfilepath);
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ShapefileDataStore shpDataStore = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            SimpleFeatureType pgfeaturetype = (SimpleFeatureType)featureCollection.getSchema();
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.init(pgfeaturetype);
            typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            pgfeaturetype = typeBuilder.buildFeatureType();
            shpDataStore.setCharset(shpChart);
            shpDataStore.createSchema(pgfeaturetype);
            Geotools.write2shp(featureCollection, shpDataStore, "");
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean geojson2pgtable(String id, String geojsonPath, String pgtableName) {
        boolean result = false;
        try {
            if (Utility.isEmpty(geojsonPath) || Utility.isEmpty(pgtableName)) {
                return result;
            }
            FeatureJSON featureJSON = new FeatureJSON();
            FeatureCollection featureCollection = featureJSON.readFeatureCollection((InputStream)new FileInputStream(geojsonPath));
            Geotools.write2pg(id, featureCollection, pgtableName);
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean shp2geojson(String shpPath, String geojsonPath) {
        return this.shp2geojson(shpPath, geojsonPath, ShpCharset.UTF_8);
    }

    public boolean shp2geojson(String shpPath, String geojsonPath, Charset shpCharset) {
        boolean result = false;
        try {
            if (!Utility.valiFileForRead(shpPath) || Utility.isEmpty(geojsonPath)) {
                return result;
            }
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(new File(shpPath).toURI().toURL());
            shapefileDataStore.setCharset(shpCharset);
            ContentFeatureSource featureSource = shapefileDataStore.getFeatureSource();
            ContentFeatureCollection contentFeatureCollection = featureSource.getFeatures();
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(15));
            Utility.valiFileForWrite(geojsonPath);
            featureJSON.writeFeatureCollection((FeatureCollection)contentFeatureCollection, (Object)new File(geojsonPath));
            shapefileDataStore.dispose();
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean shp2pgtable(String id, String shpPath, String pgtableName) {
        return this.shp2pgtable(id, shpPath, pgtableName, ShpCharset.GBK);
    }

    public boolean shp2pgtable(String id, String shpPath, String pgtableName, Charset shpCharset) {
        boolean result = false;
        try {
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(new File(shpPath).toURI().toURL());
            shapefileDataStore.setCharset(shpCharset);
            ContentFeatureCollection featureCollection = shapefileDataStore.getFeatureSource().getFeatures();
            Geotools.write2pg(id, (FeatureCollection)featureCollection, pgtableName);
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean pgtable2shp(String pgtableName, String shpPath, String geomField) {
        boolean result = false;
        try {
            SimpleFeatureSource featureSource = postgisDatasore.getFeatureSource(pgtableName);
            File file = new File(shpPath);
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ShapefileDataStore shpDataStore = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            SimpleFeatureType pgfeaturetype = (SimpleFeatureType)featureSource.getSchema();
            String srid = pgfeaturetype.getGeometryDescriptor().getUserData().get("nativeSRID").toString();
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.init(pgfeaturetype);
            if (!srid.equals("0")) {
                CoordinateReferenceSystem crs = CRS.decode((String)("EPSG:" + srid), (boolean)true);
                typeBuilder.setCRS(crs);
            }
            pgfeaturetype = typeBuilder.buildFeatureType();
            shpDataStore.setCharset(Charset.forName("UTF-8"));
            shpDataStore.createSchema(pgfeaturetype);
            Geotools.write2shp(featureSource.getFeatures(), shpDataStore, geomField);
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean pgtable2geojson(String pgtableName, String geojsonpath) {
        boolean result = false;
        try {
            SimpleFeatureSource featureSource = postgisDatasore.getFeatureSource(pgtableName);
            FeatureCollection featureCollection = featureSource.getFeatures();
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(15));
            featureJSON.setEncodeNullValues(true);
            String s = featureJSON.toString(featureCollection);
            FileUtils.writeStringToFile((File)new File(geojsonpath), (String)s, (Charset)Charsets.toCharset((String)"utf-8"), (boolean)false);
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean deletePgtable(String pgtableName) {
        boolean result = false;
        try {
            postgisDatasore.removeSchema(pgtableName);
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean testCreatFeature(String featurePath) {
        boolean result = false;
        try {
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

