/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.onemap.utils;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipAndRarTools {
    public static void unrar(String sourceRarPath, String destDirPath) throws Exception {
        File sourceRar = new File(sourceRarPath);
        File destDir = new File(destDirPath);
        Archive archive = null;
        FileOutputStream fos = null;
        System.out.println("Starting \u5f00\u59cb\u89e3\u538b...");
        try {
            archive = new Archive(sourceRar);
            FileHeader fh = archive.nextFileHeader();
            int count = 0;
            File destFileName = null;
            while (fh != null) {
                System.out.println(++count + ") " + fh.getFileNameString());
                String compressFileName = fh.getFileNameString().trim();
                destFileName = new File(destDir.getAbsolutePath() + "/" + compressFileName);
                if (fh.isDirectory()) {
                    if (!destFileName.exists()) {
                        destFileName.mkdirs();
                    }
                    fh = archive.nextFileHeader();
                    continue;
                }
                if (!destFileName.getParentFile().exists()) {
                    destFileName.getParentFile().mkdirs();
                }
                fos = new FileOutputStream(destFileName);
                archive.extractFile(fh, (OutputStream)fos);
                fos.close();
                fos = null;
                fh = archive.nextFileHeader();
            }
            archive.close();
            archive = null;
            System.out.println("Finished \u89e3\u538b\u5b8c\u6210!");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (Exception exception) {}
            }
            if (archive != null) {
                try {
                    archive.close();
                    archive = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void unZip(String zipFileName, String descFileName) throws IOException {
        System.out.println("\u6587\u4ef6\u89e3\u538b\u5f00\u59cb...");
        System.setProperty("sun.zip.encoding", System.getProperty("sun.jnu.encoding"));
        System.out.println(System.getProperty("sun.zip.encoding"));
        System.out.println(System.getProperty("sun.jnu.encoding"));
        System.out.println(System.getProperty("file.encoding"));
        String descFileNames = descFileName;
        if (!descFileNames.endsWith(File.separator)) {
            descFileNames = descFileNames + File.separator;
        }
        try {
            ZipFile zipFile = new ZipFile(zipFileName, "UTF-8");
            ZipEntry entry = null;
            String entryName = null;
            String descFileDir = null;
            byte[] buf = new byte[4096];
            int readByte = 0;
            Enumeration enums = zipFile.getEntries();
            while (enums.hasMoreElements()) {
                entry = (ZipEntry)enums.nextElement();
                entryName = entry.getName();
                descFileDir = descFileNames + entryName;
                if (entry.isDirectory()) {
                    new File(descFileDir).mkdir();
                    continue;
                }
                new File(descFileDir).getParentFile().mkdir();
                File file = new File(descFileDir);
                FileOutputStream os = new FileOutputStream(file);
                InputStream is = zipFile.getInputStream(entry);
                while ((readByte = is.read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, readByte);
                }
                ((OutputStream)os).close();
                is.close();
            }
            zipFile.close();
            System.out.println("\u6587\u4ef6\u89e3\u538b\u6210\u529f!");
        }
        catch (Exception e) {
            System.out.println("\u6587\u4ef6\u89e3\u538b\u5931\u8d25!");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ZipAndRarTools.unZip("E:\\upFiles\\\u5de5\u7a0b_1627962978919.zip", "e:\\upFiles\\\u5de5\u7a0b_1627962978919");
    }
}

