/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.resManager.catalog.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.demo.resManager.catalog.entity.Rescatalog;
import org.jeecg.modules.demo.resManager.catalog.service.IRescatalogService;
import org.jeecg.modules.demo.resManager.categories.entity.Layercategories;
import org.jeecg.modules.demo.resManager.categories.service.ILayercategoriesService;
import org.jeecg.modules.demo.resManager.fields.entity.Layerfields;
import org.jeecg.modules.demo.resManager.fields.service.ILayerfieldsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u8d44\u6e90\u76ee\u5f55"})
@RestController
@RequestMapping(value={"/resManager.catalog/rescatalog"})
public class RescatalogController
extends JeecgController<Rescatalog, IRescatalogService> {
    private static final Logger log = LoggerFactory.getLogger(RescatalogController.class);
    @Autowired
    private IRescatalogService rescatalogService;
    @Autowired
    private ILayercategoriesService layercategoriesService;
    @Autowired
    private ILayerfieldsService layerfieldsService;

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2", notes="\u8d44\u6e90\u76ee\u5f55-\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2")
    @GetMapping(value={"/resList"})
    public Result<?> getResList() {
        List<Object> resList = new ArrayList();
        resList = this.getResListByPid("0");
        return Result.OK(resList);
    }

    private List<JSONObject> getResListByPid(String pid) {
        ArrayList<JSONObject> resList = new ArrayList<JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(Rescatalog::getPid, (Object)pid)).orderByAsc(Rescatalog::getDisplayorder);
        List resCatalogs = this.rescatalogService.list((Wrapper)queryWrapper);
        if (resCatalogs.size() > 0) {
            for (int i = 0; i < resCatalogs.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                Rescatalog rescatalog = (Rescatalog)resCatalogs.get(i);
                String has_child = rescatalog.getHasChild();
                if (has_child.equals("1")) {
                    jsonObject.put("id", (Object)rescatalog.getId());
                    jsonObject.put("name", (Object)rescatalog.getAlias());
                    jsonObject.put("displayorder", (Object)rescatalog.getDisplayorder());
                    jsonObject.put("layers", this.getResListByPid(rescatalog.getId()));
                } else {
                    jsonObject.put("id", (Object)rescatalog.getId());
                    jsonObject.put("name", (Object)rescatalog.getName());
                    jsonObject.put("alias", (Object)rescatalog.getAlias());
                    jsonObject.put("url", (Object)rescatalog.getUrl());
                    jsonObject.put("dataport", (Object)rescatalog.getDataport());
                    jsonObject.put("relfield", (Object)rescatalog.getRelfield());
                    jsonObject.put("legend", (Object)rescatalog.getLegend());
                    jsonObject.put("visible", (Object)Boolean.parseBoolean(rescatalog.getVisible()));
                    jsonObject.put("appvisible", (Object)Boolean.parseBoolean(rescatalog.getAppvisible()));
                    jsonObject.put("sourceName", (Object)rescatalog.getSourcename());
                    jsonObject.put("zIndex", (Object)rescatalog.getZindex());
                    jsonObject.put("displayorder", (Object)rescatalog.getDisplayorder());
                    LambdaQueryWrapper fieldsQueryWrapper = new LambdaQueryWrapper();
                    fieldsQueryWrapper.eq(Layerfields::getLayername, (Object)rescatalog.getName());
                    fieldsQueryWrapper.orderByAsc(Layerfields::getXh);
                    List layerFields = this.layerfieldsService.list((Wrapper)fieldsQueryWrapper);
                    ArrayList<JSONObject> fieldList = new ArrayList<JSONObject>();
                    if (layerFields.size() > 0) {
                        for (int j = 0; j < layerFields.size(); ++j) {
                            JSONObject fieldJson = new JSONObject();
                            Layerfields layerField = (Layerfields)layerFields.get(j);
                            fieldJson.put("name", (Object)layerField.getName());
                            fieldJson.put("label", (Object)layerField.getAlias());
                            fieldList.add(fieldJson);
                        }
                    }
                    jsonObject.put("fields", fieldList);
                    LambdaQueryWrapper categoriesQueryWrapper = new LambdaQueryWrapper();
                    categoriesQueryWrapper.eq(Layercategories::getLayername, (Object)rescatalog.getName());
                    List layerCategories = this.layercategoriesService.list((Wrapper)categoriesQueryWrapper);
                    ArrayList<JSONObject> categoryList = new ArrayList<JSONObject>();
                    if (layerCategories.size() > 0) {
                        for (int j = 0; j < layerCategories.size(); ++j) {
                            JSONObject categoryJson = new JSONObject();
                            Layercategories layerCategory = (Layercategories)layerCategories.get(j);
                            categoryJson.put("name", (Object)layerCategory.getLegendname());
                            categoryJson.put("img", (Object)layerCategory.getLegendimg());
                            categoryList.add(categoryJson);
                        }
                    }
                    jsonObject.put("categories", categoryList);
                }
                resList.add(jsonObject);
            }
        }
        return resList;
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u8d44\u6e90\u76ee\u5f55-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/rootList"})
    public Result<?> queryPageList(Rescatalog rescatalog, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String hasQuery = req.getParameter("hasQuery");
        if (hasQuery != null && "true".equals(hasQuery)) {
            QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rescatalog, (Map)req.getParameterMap());
            List<Rescatalog> list = this.rescatalogService.queryTreeListNoPage((QueryWrapper<Rescatalog>)queryWrapper);
            Page pageList = new Page(1L, 10L, (long)list.size());
            pageList.setRecords(list);
            return Result.OK((Object)pageList);
        }
        String parentId = rescatalog.getPid();
        if (oConvertUtils.isEmpty((Object)parentId)) {
            parentId = "0";
        }
        rescatalog.setPid(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rescatalog, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"pid", (Object)parentId);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.rescatalogService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u83b7\u53d6\u5b50\u6570\u636e")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u83b7\u53d6\u5b50\u6570\u636e", notes="\u8d44\u6e90\u76ee\u5f55-\u83b7\u53d6\u5b50\u6570\u636e")
    @GetMapping(value={"/childList"})
    public Result<?> queryPageList(Rescatalog rescatalog, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rescatalog, (Map)req.getParameterMap());
        List list = this.rescatalogService.list((Wrapper)queryWrapper);
        Page pageList = new Page(1L, 10L, (long)list.size());
        pageList.setRecords(list);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u6279\u91cf\u83b7\u53d6\u5b50\u6570\u636e")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u6279\u91cf\u83b7\u53d6\u5b50\u6570\u636e", notes="\u8d44\u6e90\u76ee\u5f55-\u6279\u91cf\u83b7\u53d6\u5b50\u6570\u636e")
    @GetMapping(value={"/getChildListBatch"})
    public Result getChildListBatch(@RequestParam(value="parentIds") String parentIds) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            List<String> parentIdList = Arrays.asList(parentIds.split(","));
            queryWrapper.in((Object)"pid", parentIdList);
            List list = this.rescatalogService.list((Wrapper)queryWrapper);
            Page pageList = new Page(1L, 10L, (long)list.size());
            pageList.setRecords(list);
            return Result.OK((Object)pageList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u6279\u91cf\u67e5\u8be2\u5b50\u8282\u70b9\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u6dfb\u52a0")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u6dfb\u52a0", notes="\u8d44\u6e90\u76ee\u5f55-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody Rescatalog rescatalog) {
        this.rescatalogService.addRescatalog(rescatalog);
        return Result.OK((Object)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u7f16\u8f91")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u7f16\u8f91", notes="\u8d44\u6e90\u76ee\u5f55-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody Rescatalog rescatalog) {
        this.rescatalogService.updateRescatalog(rescatalog);
        return Result.OK((Object)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u901a\u8fc7id\u5220\u9664", notes="\u8d44\u6e90\u76ee\u5f55-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.rescatalogService.deleteRescatalog(id);
        return Result.OK((Object)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u6279\u91cf\u5220\u9664", notes="\u8d44\u6e90\u76ee\u5f55-\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.rescatalogService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((Object)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u901a\u8fc7id\u67e5\u8be2", notes="\u8d44\u6e90\u76ee\u5f55-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        Rescatalog rescatalog = (Rescatalog)this.rescatalogService.getById((Serializable)((Object)id));
        if (rescatalog == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)rescatalog);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, Rescatalog rescatalog) {
        return super.exportXls(request, (Object)rescatalog, Rescatalog.class, "\u8d44\u6e90\u76ee\u5f55");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, Rescatalog.class);
    }
}

