/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.test.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.modules.demo.test.entity.JeecgDemo;
import org.jeecg.modules.demo.test.service.IJeecgDemoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5355\u8868DEMO"})
@RestController
@RequestMapping(value={"/test/jeecgDemo"})
public class JeecgDemoController
extends JeecgController<JeecgDemo, IJeecgDemoService> {
    private static final Logger log = LoggerFactory.getLogger(JeecgDemoController.class);
    @Autowired
    private IJeecgDemoService jeecgDemoService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u83b7\u53d6Demo\u6570\u636e\u5217\u8868", notes="\u83b7\u53d6\u6240\u6709Demo\u6570\u636e\u5217\u8868")
    @GetMapping(value={"/list"})
    @PermissionData(pageComponent="jeecg/JeecgDemoList")
    public Result<?> list(JeecgDemo jeecgDemo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)jeecgDemo, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.jeecgDemoService.page((IPage)page, (Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\uff1a" + pageList.getCurrent());
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570\u91cf\uff1a" + pageList.getSize());
        log.info("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + pageList.getRecords().size());
        log.info("\u6570\u636e\u603b\u6570\uff1a" + pageList.getTotal());
        return Result.OK((Object)pageList);
    }

    @PostMapping(value={"/add"})
    @AutoLog(value="\u6dfb\u52a0\u6d4b\u8bd5DEMO")
    @ApiOperation(value="\u6dfb\u52a0DEMO", notes="\u6dfb\u52a0DEMO")
    public Result<?> add(@RequestBody JeecgDemo jeecgDemo) {
        this.jeecgDemoService.save(jeecgDemo);
        return Result.OK((Object)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u7f16\u8f91DEMO", notes="\u7f16\u8f91DEMO")
    @AutoLog(value="\u7f16\u8f91DEMO", operateType=3)
    public Result<?> edit(@RequestBody JeecgDemo jeecgDemo) {
        this.jeecgDemoService.updateById(jeecgDemo);
        return Result.OK((Object)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u5220\u9664\u6d4b\u8bd5DEMO")
    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u901a\u8fc7ID\u5220\u9664DEMO", notes="\u901a\u8fc7ID\u5220\u9664DEMO")
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.jeecgDemoService.removeById((Serializable)((Object)id));
        return Result.OK((Object)"\u5220\u9664\u6210\u529f!");
    }

    @PostMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664DEMO", notes="\u6279\u91cf\u5220\u9664DEMO")
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.jeecgDemoService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((Object)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryById"})
    @ApiOperation(value="\u901a\u8fc7ID\u67e5\u8be2DEMO", notes="\u901a\u8fc7ID\u67e5\u8be2DEMO")
    public Result<?> queryById(@ApiParam(name="id", value="\u793a\u4f8bid", required=true) @RequestParam(name="id", required=true) String id) {
        JeecgDemo jeecgDemo = (JeecgDemo)this.jeecgDemoService.getById((Serializable)((Object)id));
        return Result.OK((Object)jeecgDemo);
    }

    @RequestMapping(value={"/exportXls"})
    @PermissionData(pageComponent="jeecg/JeecgDemoList")
    public ModelAndView exportXls(HttpServletRequest request, JeecgDemo jeecgDemo) {
        String exportFields = this.jeecgDemoService.getExportFields();
        return super.exportXlsSheet(request, (Object)jeecgDemo, JeecgDemo.class, "\u5355\u8868\u6a21\u578b", exportFields, Integer.valueOf(500));
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, JeecgDemo.class);
    }

    @GetMapping(value={"/redisSet"})
    public void redisSet() {
        this.redisUtil.set("name", (Object)("\u5f20\u4e09" + DateUtils.now()));
    }

    @GetMapping(value={"/redisGet"})
    public String redisGet() {
        return (String)this.redisUtil.get("name");
    }

    @GetMapping(value={"/redisSetObj"})
    public void redisSetObj() {
        JeecgDemo p = new JeecgDemo();
        p.setAge(10);
        p.setBirthday(new Date());
        p.setContent("hello");
        p.setName("\u5f20\u4e09");
        p.setSex("\u7537");
        this.redisUtil.set("user-zdh", (Object)p);
    }

    @GetMapping(value={"/redisGetObj"})
    public Object redisGetObj() {
        return this.redisUtil.get("user-zdh");
    }

    @GetMapping(value={"/redis/{id}"})
    public JeecgDemo redisGetJeecgDemo(@PathVariable(value="id") String id) {
        JeecgDemo t = this.jeecgDemoService.getByIdCacheable(id);
        log.info(t.toString());
        return t;
    }

    @RequestMapping(value={"/html"})
    public ModelAndView ftl(ModelAndView modelAndView) {
        modelAndView.setViewName("demo3");
        ArrayList<String> userList = new ArrayList<String>();
        userList.add("admin");
        userList.add("user1");
        userList.add("user2");
        log.info("--------------test--------------");
        modelAndView.addObject("userList", userList);
        return modelAndView;
    }

    @PostMapping(value={"/testOnlineAdd"})
    public Result<?> testOnlineAdd(@RequestBody JSONObject json) {
        log.info(json.toJSONString());
        return Result.OK((Object)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @GetMapping(value={"/mpList"})
    @PermissionData(pageComponent="jeecg/JeecgDemoList")
    public Result<?> loadMpPermissonList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryGenerator.installAuthMplus((QueryWrapper)queryWrapper, JeecgDemo.class);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.jeecgDemoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @GetMapping(value={"/sqlList"})
    @PermissionData(pageComponent="jeecg/JeecgDemoList")
    public Result<?> loadSqlPermissonList(JeecgDemo jeecgDemo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        IPage<JeecgDemo> pageList = this.jeecgDemoService.queryListWithPermission(pageSize, pageNo);
        return Result.OK(pageList);
    }
}

