/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.test.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.demo.test.entity.JeecgOrderCustomer;
import org.jeecg.modules.demo.test.entity.JeecgOrderMain;
import org.jeecg.modules.demo.test.entity.JeecgOrderTicket;
import org.jeecg.modules.demo.test.service.IJeecgOrderCustomerService;
import org.jeecg.modules.demo.test.service.IJeecgOrderMainService;
import org.jeecg.modules.demo.test.service.IJeecgOrderTicketService;
import org.jeecg.modules.demo.test.vo.JeecgOrderMainPage;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/test/jeecgOrderMain"})
public class JeecgOrderMainController
extends JeecgController<JeecgOrderMain, IJeecgOrderMainService> {
    private static final Logger log = LoggerFactory.getLogger(JeecgOrderMainController.class);
    @Autowired
    private IJeecgOrderMainService jeecgOrderMainService;
    @Autowired
    private IJeecgOrderCustomerService jeecgOrderCustomerService;
    @Autowired
    private IJeecgOrderTicketService jeecgOrderTicketService;

    @GetMapping(value={"/list"})
    public Result<?> queryPageList(JeecgOrderMain jeecgOrderMain, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)jeecgOrderMain, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.jeecgOrderMainService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody JeecgOrderMainPage jeecgOrderMainPage) {
        JeecgOrderMain jeecgOrderMain = new JeecgOrderMain();
        BeanUtils.copyProperties((Object)jeecgOrderMainPage, (Object)jeecgOrderMain);
        this.jeecgOrderMainService.saveMain(jeecgOrderMain, jeecgOrderMainPage.getJeecgOrderCustomerList(), jeecgOrderMainPage.getJeecgOrderTicketList());
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @PostMapping(value={"/edit"})
    public Result<?> eidt(@RequestBody JeecgOrderMainPage jeecgOrderMainPage) {
        JeecgOrderMain jeecgOrderMain = new JeecgOrderMain();
        BeanUtils.copyProperties((Object)jeecgOrderMainPage, (Object)jeecgOrderMain);
        this.jeecgOrderMainService.updateCopyMain(jeecgOrderMain, jeecgOrderMainPage.getJeecgOrderCustomerList(), jeecgOrderMainPage.getJeecgOrderTicketList());
        return Result.ok((String)"\u7f16\u8f91\u6210\u529f\uff01");
    }

    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.jeecgOrderMainService.delMain(id);
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @PostMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.jeecgOrderMainService.delBatchMain(Arrays.asList(ids.split(",")));
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        JeecgOrderMain jeecgOrderMain = (JeecgOrderMain)this.jeecgOrderMainService.getById((Serializable)((Object)id));
        return Result.ok((Object)jeecgOrderMain);
    }

    @GetMapping(value={"/queryOrderCustomerListByMainId"})
    public Result<?> queryOrderCustomerListByMainId(@RequestParam(name="id", required=true) String id) {
        List<JeecgOrderCustomer> jeecgOrderCustomerList = this.jeecgOrderCustomerService.selectCustomersByMainId(id);
        return Result.ok(jeecgOrderCustomerList);
    }

    @GetMapping(value={"/queryOrderTicketListByMainId"})
    public Result<?> queryOrderTicketListByMainId(@RequestParam(name="id", required=true) String id) {
        List<JeecgOrderTicket> jeecgOrderTicketList = this.jeecgOrderTicketService.selectTicketsByMainId(id);
        return Result.ok(jeecgOrderTicketList);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, JeecgOrderMain jeecgOrderMain) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)jeecgOrderMain, (Map)request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<JeecgOrderMainPage> pageList = new ArrayList<JeecgOrderMainPage>();
        List jeecgOrderMainList = this.jeecgOrderMainService.list((Wrapper)queryWrapper);
        for (JeecgOrderMain orderMain : jeecgOrderMainList) {
            JeecgOrderMainPage vo = new JeecgOrderMainPage();
            BeanUtils.copyProperties((Object)orderMain, (Object)vo);
            List<JeecgOrderTicket> jeecgOrderTicketList = this.jeecgOrderTicketService.selectTicketsByMainId(orderMain.getId());
            vo.setJeecgOrderTicketList(jeecgOrderTicketList);
            List<JeecgOrderCustomer> jeecgOrderCustomerList = this.jeecgOrderCustomerService.selectCustomersByMainId(orderMain.getId());
            vo.setJeecgOrderCustomerList(jeecgOrderCustomerList);
            pageList.add(vo);
        }
        mv.addObject("fileName", (Object)"\u4e00\u5bf9\u591a\u8ba2\u5355\u793a\u4f8b");
        mv.addObject("entity", JeecgOrderMainPage.class);
        mv.addObject("params", (Object)new ExportParams("\u81ea\u5b9a\u4e49\u5bfc\u51faExcel\u5185\u5bb9\u6807\u9898", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u81ea\u5b9a\u4e49Sheet\u540d\u5b57"));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(2);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), JeecgOrderMainPage.class, (ImportParams)params);
                for (JeecgOrderMainPage page : list) {
                    JeecgOrderMain po = new JeecgOrderMain();
                    BeanUtils.copyProperties((Object)page, (Object)po);
                    this.jeecgOrderMainService.saveMain(po, page.getJeecgOrderCustomerList(), page.getJeecgOrderTicketList());
                }
                Result result = Result.ok((String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

