/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.draw;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.draw.ILineDrawer;

public class DottedLine
implements ILineDrawer {
    protected float gap = 4.0f;
    private float lineWidth = 1.0f;
    private Color color = ColorConstants.BLACK;

    public DottedLine() {
    }

    public DottedLine(float lineWidth, float gap) {
        this.lineWidth = lineWidth;
        this.gap = gap;
    }

    public DottedLine(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public void draw(PdfCanvas canvas, Rectangle drawArea) {
        canvas.saveState().setLineWidth(this.lineWidth).setStrokeColor(this.color).setLineDash(0.0f, this.gap, this.gap / 2.0f).setLineCapStyle(1).moveTo(drawArea.getX(), drawArea.getY() + this.lineWidth / 2.0f).lineTo(drawArea.getX() + drawArea.getWidth(), drawArea.getY() + this.lineWidth / 2.0f).stroke().restoreState();
    }

    public float getGap() {
        return this.gap;
    }

    public void setGap(float gap) {
        this.gap = gap;
    }

    @Override
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }
}

