/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.listener;

import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.filter.IEventFilter;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FilteredEventListener
implements IEventListener {
    protected final List<IEventListener> delegates = new ArrayList<IEventListener>();
    protected final List<IEventFilter[]> filters = new ArrayList<IEventFilter[]>();

    public FilteredEventListener() {
    }

    public FilteredEventListener(IEventListener delegate, IEventFilter ... filterSet) {
        this();
        this.attachEventListener(delegate, filterSet);
    }

    public <T extends IEventListener> T attachEventListener(T delegate, IEventFilter ... filterSet) {
        this.delegates.add(delegate);
        this.filters.add(filterSet);
        return delegate;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            IEventListener delegate = this.delegates.get(i);
            boolean filtersPassed = delegate.getSupportedEvents() == null || delegate.getSupportedEvents().contains((Object)type);
            for (IEventFilter filter : this.filters.get(i)) {
                if (filter.accept(data, type)) continue;
                filtersPassed = false;
                break;
            }
            if (!filtersPassed) continue;
            delegate.eventOccurred(data, type);
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return null;
    }
}

