/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.RootElement;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILargeElement;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.RootRenderer;

public class Document
extends RootElement<Document> {
    @Deprecated
    protected float leftMargin = 36.0f;
    @Deprecated
    protected float rightMargin = 36.0f;
    @Deprecated
    protected float topMargin = 36.0f;
    @Deprecated
    protected float bottomMargin = 36.0f;

    public Document(PdfDocument pdfDoc) {
        this(pdfDoc, pdfDoc.getDefaultPageSize());
    }

    public Document(PdfDocument pdfDoc, PageSize pageSize) {
        this(pdfDoc, pageSize, true);
    }

    public Document(PdfDocument pdfDoc, PageSize pageSize, boolean immediateFlush) {
        this.pdfDocument = pdfDoc;
        this.pdfDocument.setDefaultPageSize(pageSize);
        this.immediateFlush = immediateFlush;
    }

    @Override
    public void close() {
        if (this.rootRenderer != null) {
            this.rootRenderer.close();
        }
        this.pdfDocument.close();
    }

    public Document add(AreaBreak areaBreak) {
        this.checkClosingStatus();
        this.childElements.add(areaBreak);
        this.ensureRootRendererNotNull().addChild(areaBreak.createRendererSubTree());
        if (this.immediateFlush) {
            this.childElements.remove(this.childElements.size() - 1);
        }
        return this;
    }

    @Override
    public Document add(IBlockElement element) {
        this.checkClosingStatus();
        super.add(element);
        if (element instanceof ILargeElement) {
            ((ILargeElement)((Object)element)).setDocument(this);
            ((ILargeElement)((Object)element)).flushContent();
        }
        return this;
    }

    public PdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public void setRenderer(DocumentRenderer documentRenderer) {
        this.rootRenderer = documentRenderer;
    }

    public void flush() {
        this.rootRenderer.flush();
    }

    public void relayout() {
        IRenderer nextRelayoutRenderer;
        if (this.immediateFlush) {
            throw new IllegalStateException("Operation not supported with immediate flush");
        }
        IRenderer iRenderer = nextRelayoutRenderer = this.rootRenderer != null ? this.rootRenderer.getNextRenderer() : null;
        if (nextRelayoutRenderer == null || !(nextRelayoutRenderer instanceof RootRenderer)) {
            nextRelayoutRenderer = new DocumentRenderer(this, this.immediateFlush);
        }
        while (this.pdfDocument.getNumberOfPages() > 0) {
            this.pdfDocument.removePage(this.pdfDocument.getNumberOfPages());
        }
        this.rootRenderer = (RootRenderer)nextRelayoutRenderer;
        for (IElement element : this.childElements) {
            this.createAndAddRendererSubTree(element);
        }
    }

    public float getLeftMargin() {
        Float property = (Float)this.getProperty(44);
        return (property != null ? property : (Float)this.getDefaultProperty(44)).floatValue();
    }

    public void setLeftMargin(float leftMargin) {
        this.setProperty(44, Float.valueOf(leftMargin));
        this.leftMargin = leftMargin;
    }

    public float getRightMargin() {
        Float property = (Float)this.getProperty(45);
        return (property != null ? property : (Float)this.getDefaultProperty(45)).floatValue();
    }

    public void setRightMargin(float rightMargin) {
        this.setProperty(45, Float.valueOf(rightMargin));
        this.rightMargin = rightMargin;
    }

    public float getTopMargin() {
        Float property = (Float)this.getProperty(46);
        return (property != null ? property : (Float)this.getDefaultProperty(46)).floatValue();
    }

    public void setTopMargin(float topMargin) {
        this.setProperty(46, Float.valueOf(topMargin));
        this.topMargin = topMargin;
    }

    public float getBottomMargin() {
        Float property = (Float)this.getProperty(43);
        return (property != null ? property : (Float)this.getDefaultProperty(43)).floatValue();
    }

    public void setBottomMargin(float bottomMargin) {
        this.setProperty(43, Float.valueOf(bottomMargin));
        this.bottomMargin = bottomMargin;
    }

    public void setMargins(float topMargin, float rightMargin, float bottomMargin, float leftMargin) {
        this.setTopMargin(topMargin);
        this.setRightMargin(rightMargin);
        this.setBottomMargin(bottomMargin);
        this.setLeftMargin(leftMargin);
    }

    public Rectangle getPageEffectiveArea(PageSize pageSize) {
        float x = pageSize.getLeft() + this.getLeftMargin();
        float y = pageSize.getBottom() + this.getBottomMargin();
        float width = pageSize.getWidth() - this.getLeftMargin() - this.getRightMargin();
        float height = pageSize.getHeight() - this.getBottomMargin() - this.getTopMargin();
        return new Rectangle(x, y, width, height);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return (T1)Float.valueOf(36.0f);
            }
        }
        return super.getDefaultProperty(property);
    }

    @Override
    protected RootRenderer ensureRootRendererNotNull() {
        if (this.rootRenderer == null) {
            this.rootRenderer = new DocumentRenderer(this, this.immediateFlush);
        }
        return this.rootRenderer;
    }

    protected void checkClosingStatus() {
        if (this.getPdfDocument().isClosed()) {
            throw new PdfException("Document was closed. It is impossible to execute action.");
        }
    }
}

