/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.kernel.font.Type3Font;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontSetCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontSet {
    private static final AtomicLong lastId = new AtomicLong();
    private final Set<FontInfo> fonts = new LinkedHashSet<FontInfo>();
    private final Map<FontInfo, FontProgram> fontPrograms = new HashMap<FontInfo, FontProgram>();
    private final long id = lastId.incrementAndGet();

    public int addDirectory(String dir, boolean scanSubdirectories) {
        int count = 0;
        String[] files = FileUtil.listFilesInDirectory((String)dir, (boolean)scanSubdirectories);
        if (files == null) {
            return 0;
        }
        for (String file : files) {
            try {
                String suffix;
                String string = suffix = file.length() < 4 ? null : file.substring(file.length() - 4).toLowerCase();
                if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                    String pfb = file.substring(0, file.length() - 4) + ".pfb";
                    if (!FileUtil.fileExists((String)pfb) || !this.addFont(file)) continue;
                    ++count;
                    continue;
                }
                if (!".ttf".equals(suffix) && !".otf".equals(suffix) && !".ttc".equals(suffix) || !this.addFont(file)) continue;
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    public int addDirectory(String dir) {
        return this.addDirectory(dir, false);
    }

    public boolean addFont(FontProgram fontProgram, String encoding, String alias) {
        if (fontProgram == null) {
            return false;
        }
        if (fontProgram instanceof Type3Font) {
            Logger logger = LoggerFactory.getLogger(FontSet.class);
            logger.error("Type 3 font cannot be added to FontSet. Custom FontProvider class may be created for this purpose.");
            return false;
        }
        FontInfo fi = FontInfo.create(fontProgram, encoding, alias);
        if (this.addFont(fi)) {
            this.fontPrograms.put(fi, fontProgram);
            return true;
        }
        return false;
    }

    public boolean addFont(FontProgram fontProgram, String encoding) {
        return this.addFont(fontProgram, encoding, null);
    }

    public boolean addFont(String fontPath, String encoding, String alias) {
        return this.addFont(FontInfo.create(fontPath, encoding, alias));
    }

    public boolean addFont(String fontPath, String encoding) {
        return this.addFont(FontInfo.create(fontPath, encoding, null));
    }

    public boolean addFont(byte[] fontData, String encoding, String alias) {
        return this.addFont(FontInfo.create(fontData, encoding, alias));
    }

    public boolean addFont(byte[] fontData, String encoding) {
        return this.addFont(FontInfo.create(fontData, encoding, null));
    }

    public boolean addFont(String fontPath) {
        return this.addFont(fontPath, null, null);
    }

    public boolean addFont(byte[] fontData) {
        return this.addFont(fontData, null, null);
    }

    public boolean addFont(FontInfo fontInfo, String alias) {
        return this.addFont(FontInfo.create(fontInfo, alias));
    }

    public final boolean addFont(FontInfo fontInfo) {
        if (fontInfo != null && !this.fonts.contains(fontInfo)) {
            this.fonts.add(fontInfo);
            return true;
        }
        return false;
    }

    public boolean contains(String fontName) {
        if (fontName == null || fontName.length() == 0) {
            return false;
        }
        fontName = fontName.toLowerCase();
        for (FontInfo fi : this.getFonts()) {
            if (!fontName.equals(fi.getDescriptor().getFullNameLowerCase()) && !fontName.equals(fi.getDescriptor().getFontNameLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Collection<FontInfo> get(String fontName) {
        if (fontName == null || fontName.length() == 0) {
            return Collections.emptyList();
        }
        fontName = fontName.toLowerCase();
        ArrayList<FontInfo> list = new ArrayList<FontInfo>();
        for (FontInfo fi : this.getFonts()) {
            if (!fontName.equals(fi.getDescriptor().getFullNameLowerCase()) && !fontName.equals(fi.getDescriptor().getFontNameLowerCase())) continue;
            list.add(fi);
        }
        return list;
    }

    public Collection<FontInfo> getFonts() {
        return this.getFonts(null);
    }

    public Collection<FontInfo> getFonts(FontSet tempFonts) {
        return new FontSetCollection(this.fonts, tempFonts != null ? tempFonts.fonts : null);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.fonts.size();
    }

    long getId() {
        return this.id;
    }

    FontProgram getFontProgram(FontInfo fontInfo) {
        return this.fontPrograms.get(fontInfo);
    }
}

