/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.factory;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.annotation.MiniDao;
import org.jeecgframework.minidao.factory.MiniDaoBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class MiniDaoClassPathMapperScanner
extends ClassPathBeanDefinitionScanner {
    private static final Log logger = LogFactory.getLog(MiniDaoClassPathMapperScanner.class);

    public MiniDaoClassPathMapperScanner(BeanDefinitionRegistry registry, Class<? extends Annotation> annotation) {
        super(registry, false);
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
        if (!MiniDao.class.equals(annotation)) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MiniDao.class));
        }
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            logger.warn((Object)("No Dao interface was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        }
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            definition.getPropertyValues().add("proxy", (Object)this.getRegistry().getBeanDefinition("miniDaoHandler"));
            definition.getPropertyValues().add("daoInterface", (Object)definition.getBeanClassName());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("register minidao name is { " + definition.getBeanClassName() + " }"));
            }
            definition.setBeanClass(MiniDaoBeanFactory.class);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }
}

