/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.batch.builder;

import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisCursorItemReader;

public class MyBatisCursorItemReaderBuilder<T> {
    private SqlSessionFactory sqlSessionFactory;
    private String queryId;
    private Map<String, Object> parameterValues;
    private Boolean saveState;
    private Integer maxItemCount;

    public MyBatisCursorItemReaderBuilder<T> sqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public MyBatisCursorItemReaderBuilder<T> queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    public MyBatisCursorItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public MyBatisCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MyBatisCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MyBatisCursorItemReader<T> build() {
        MyBatisCursorItemReader reader = new MyBatisCursorItemReader();
        reader.setSqlSessionFactory(this.sqlSessionFactory);
        reader.setQueryId(this.queryId);
        reader.setParameterValues(this.parameterValues);
        Optional.ofNullable(this.saveState).ifPresent(arg_0 -> reader.setSaveState(arg_0));
        Optional.ofNullable(this.maxItemCount).ifPresent(arg_0 -> reader.setMaxItemCount(arg_0));
        return reader;
    }
}

