/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.OperationBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.OperationModelContextsBuilder;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.wrapper.NameValueExpression;

public class OperationContext {
    private final OperationBuilder operationBuilder;
    private final RequestMethod requestMethod;
    private final RequestMappingContext requestContext;
    private final int operationIndex;

    public OperationContext(OperationBuilder operationBuilder, RequestMethod requestMethod, RequestMappingContext requestContext, int operationIndex) {
        this.operationBuilder = operationBuilder;
        this.requestMethod = requestMethod;
        this.requestContext = requestContext;
        this.operationIndex = operationIndex;
    }

    public OperationBuilder operationBuilder() {
        return this.operationBuilder;
    }

    public HttpMethod httpMethod() {
        return HttpMethod.valueOf((String)this.requestMethod.toString());
    }

    public int operationIndex() {
        return this.operationIndex;
    }

    public List<ResponseMessage> getGlobalResponseMessages(String forHttpMethod) {
        DocumentationContext documentationContext = this.getDocumentationContext();
        if (documentationContext.getGlobalResponseMessages().containsKey(RequestMethod.valueOf((String)forHttpMethod))) {
            return documentationContext.getGlobalResponseMessages().get(RequestMethod.valueOf((String)forHttpMethod));
        }
        return new ArrayList<ResponseMessage>();
    }

    public List<Parameter> getGlobalOperationParameters() {
        return BuilderDefaults.nullToEmptyList(this.getDocumentationContext().getGlobalRequestParameters());
    }

    public List<SecurityContext> securityContext() {
        return this.getDocumentationContext().getSecurityContexts().stream().filter(this.pathMatches()).collect(Collectors.toList());
    }

    private Predicate<SecurityContext> pathMatches() {
        return input -> input.securityForOperation(this) != null;
    }

    public String requestMappingPattern() {
        return this.requestContext.getRequestMappingPattern();
    }

    public DocumentationContext getDocumentationContext() {
        return this.requestContext.getDocumentationContext();
    }

    public OperationModelContextsBuilder operationModelsBuilder() {
        return this.requestContext.operationModelsBuilder();
    }

    public Map<String, Set<Model>> getKnownModels() {
        return this.requestContext.getModelMap();
    }

    public DocumentationType getDocumentationType() {
        return this.getDocumentationContext().getDocumentationType();
    }

    public AlternateTypeProvider getAlternateTypeProvider() {
        return this.getDocumentationContext().getAlternateTypeProvider();
    }

    public ResolvedType alternateFor(ResolvedType resolved) {
        return this.getAlternateTypeProvider().alternateFor(resolved);
    }

    public Set<? extends MediaType> produces() {
        return this.requestContext.produces();
    }

    public Set<? extends MediaType> consumes() {
        return this.requestContext.consumes();
    }

    public Set<Class> getIgnorableParameterTypes() {
        return this.getDocumentationContext().getIgnorableParameterTypes().stream().collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public GenericTypeNamingStrategy getGenericsNamingStrategy() {
        return this.getDocumentationContext().getGenericsNamingStrategy();
    }

    public Set<NameValueExpression<String>> headers() {
        return this.requestContext.headers();
    }

    public Set<NameValueExpression<String>> params() {
        return this.requestContext.params();
    }

    public String getName() {
        return this.requestContext.getName();
    }

    public String getGroupName() {
        return this.requestContext.getGroupName();
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.requestContext.getParameters();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return this.requestContext.findAnnotation(annotation);
    }

    public ResolvedType getReturnType() {
        return this.requestContext.getReturnType();
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return this.requestContext.findControllerAnnotation(annotation);
    }

    public <T extends Annotation> List<T> findAllAnnotations(Class<T> annotation) {
        return this.requestContext.findAnnotations(annotation);
    }
}

