/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.annotations;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.springframework.core.annotation.AnnotationUtils;

public class Annotations {
    private Annotations() {
        throw new UnsupportedOperationException();
    }

    public static Optional<ApiParam> findApiParamAnnotation(AnnotatedElement annotated) {
        return Optional.ofNullable(AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiParam.class));
    }

    public static List<ApiResponses> findApiResponsesAnnotations(AnnotatedElement annotated) {
        ApiResponses parentLevel;
        ArrayList<ApiResponses> results = new ArrayList<ApiResponses>();
        ApiResponses currentLevel = (ApiResponses)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiResponses.class);
        if (currentLevel != null) {
            results.add(currentLevel);
        }
        if (annotated instanceof Method && (parentLevel = (ApiResponses)AnnotationUtils.findAnnotation(((Method)annotated).getDeclaringClass(), ApiResponses.class)) != null) {
            results.add(parentLevel);
        }
        return results;
    }

    public static Function<ApiOperation, ResolvedType> resolvedTypeFromOperation(TypeResolver typeResolver, ResolvedType defaultType) {
        return annotation -> Annotations.getResolvedType(annotation, typeResolver, defaultType);
    }

    public static Function<ApiResponse, ResolvedType> resolvedTypeFromResponse(TypeResolver typeResolver, ResolvedType defaultType) {
        return annotation -> Annotations.getResolvedType(annotation, typeResolver, defaultType);
    }

    static ResolvedType getResolvedType(ApiOperation annotation, TypeResolver resolver, ResolvedType defaultType) {
        String responseContainer;
        Class response;
        if (null != annotation && Annotations.resolvedType(resolver, response = annotation.response(), responseContainer = annotation.responseContainer()).isPresent()) {
            return Annotations.resolvedType(resolver, response, responseContainer).get();
        }
        return defaultType;
    }

    static ResolvedType getResolvedType(ApiResponse annotation, TypeResolver resolver, ResolvedType defaultType) {
        String responseContainer;
        Class response;
        if (null != annotation && Annotations.resolvedType(resolver, response = annotation.response(), responseContainer = annotation.responseContainer()).isPresent()) {
            return Annotations.resolvedType(resolver, response, responseContainer).get();
        }
        return defaultType;
    }

    private static Optional<ResolvedType> resolvedType(TypeResolver resolver, Class<?> response, String responseContainer) {
        if (Annotations.isNotVoid(response)) {
            if ("List".compareToIgnoreCase(responseContainer) == 0) {
                return Optional.of(resolver.resolve(List.class, new Type[]{response}));
            }
            if ("Set".compareToIgnoreCase(responseContainer) == 0) {
                return Optional.of(resolver.resolve(Set.class, new Type[]{response}));
            }
            return Optional.of(resolver.resolve(response, new Type[0]));
        }
        return Optional.empty();
    }

    private static boolean isNotVoid(Class<?> response) {
        return Void.class != response && Void.TYPE != response;
    }
}

