import ImageLayer from 'ol/layer/Image'
import ImageWMS from 'ol/source/ImageWMS'
import $ from "jquery";

let ip = "222.133.41.37:9212";   //http://222.133.41.37:9212/geoserver/ows
// let ip ="127.0.0.1:8080"
const geoserverUrl = "http://" + ip +"/geoserver/ows";
//河湖管理范围线图层
let glfwxLayer = new ImageLayer({
    name:'glfwx',
    source: new ImageWMS({
        ratio: 1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:dzhhglfwx'
        },
        serverType: "geoserver"
    }),
    zIndex: 11
});
//公告牌图层
let ggpLayer = new ImageLayer({
    name:'ggp',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:rm_ggpgeo'
        },
        serverType: "geoserver"
    }),
    zIndex: 12
})
//界桩点图层
let jzdLayer = new ImageLayer({
    name:'jzd',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:rm_jzdgeo'
        },
        serverType: "geoserver"
    }),
    zIndex: 13
})
//临水控制线图层
let lskzxLayer = new ImageLayer({
    name:'lskzx',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:lskzx'
        },
        serverType: "geoserver"
    }),
    zIndex: 13
})
//外缘控制线图层
let wykzxLayer = new ImageLayer({
    name:'wykzx',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:wykzx'
        },
        serverType: "geoserver"
    }),
    zIndex: 13
})
//岸线功能区图层
let axgnqLayer = new ImageLayer({
    name:'axgnq',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:rm_axghgnqgeo'
        },
        serverType: "geoserver"
    }),
    zIndex: 13
})
//泵站工程图层
let bzgcLayer = new ImageLayer({
    name:'bzgc',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:rm_bzgcgeo'
        },
        serverType: "geoserver"
    }),
    zIndex: 13
})
//闸坝工程图层
let zbgcLayer = new ImageLayer({
    name:'zbgc',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:rm_zbgcgeo'
        },
        serverType: "geoserver"
    }),
    zIndex: 13
})
//泵站工程图层
let dfgcLayer = new ImageLayer({
    name:'dfgc',
    source:new ImageWMS({
        radio:1,
        url: geoserverUrl,
        params: {
            LAYERS: 'dzsl:rm_dfgcgeo'
        },
        serverType: "geoserver"
    }),
    zIndex: 13
})
/**
 *@name:加载业务图层
 *@param:map(当前地图)
 *@author: chentongjian
 *@time: 2021-10-25 11:55:07
 */
let loadBussLayer = function(map) {
  //划界图层
  map.addLayer(glfwxLayer);
  map.addLayer(jzdLayer);
  map.addLayer(ggpLayer);
  //岸线规划图层
  map.addLayer(axgnqLayer);
  map.addLayer(wykzxLayer);
  map.addLayer(lskzxLayer);
}

let loadLayerByName = function (map,layerName) {
    if (!map || !layerName){
        return;
    }
    switch (layerName) {
        case 'glfwx':
        {
            map.addLayer(glfwxLayer);
            break;
        }
        case 'jzd':
        {
            map.addLayer(jzdLayer);
            break;
        }
        case 'ggp':
        {
            map.addLayer(ggpLayer);
            break;
        }
        case 'axgnq':
        {
            map.addLayer(axgnqLayer);
            break;
        }
        case 'wykzx':
        {
            map.addLayer(wykzxLayer);
            break;
        }
        case 'lskzx':
        {
            map.addLayer(lskzxLayer);
            break;
        }
        case 'bzgc':
        {
            map.addLayer(bzgcLayer);
            break;
        }
        case 'zbgc':
        {
            map.addLayer(zbgcLayer);
            break;
        }
        case 'dfgc':
        {
            map.addLayer(dfgcLayer);
            break;
        }
        default:
            break;
    }
}

export {loadBussLayer,loadLayerByName}