import $ from 'jquery';
import  {unByKey} from 'ol/Observable';
import Overlay from 'ol/Overlay';
import * as measureTool from './measure'

/**
 * /marker点击事件
 * （因Overlay覆盖物在地图上方，无法触发地图点击事件，将屏幕坐标和地图坐标进行转换，然后进行空间查询）
 */
let markerClick = function (evt) {
    debugger;
    let pixel_x = evt.clientX;
    let pixel_y = evt.clientY;
    let pixel = [];
    pixel.push(pixel_x);
    pixel.push(pixel_y);
    let coordinate = map.getCoordinateFromPixel(pixel);
    identifyByCoordinate(coordinate);
}

//地图点击事件
let mapClick = function (evt) {
    let coordinate = evt.coordinate;
    identifyByCoordinate(coordinate);
}

let queryTypeChange = function () {

}

let getLayerByName = function (layerName) {
    let layer = null;
    let layers = this.baseMapMap.getLayers();
    let layerCount = layers.getLength();
    for (let i = 0; i < layerCount; i++) {
        let name = layers.item(i).get('name');
        if (name == layerName) {
            layer = layers.item(i);
        }
    }
    return layer;
}
//通过地图点坐标进行空间查询
let identifyByCoordinate = function (coords) {
    let map = this.baseMapMap;
    let view = this.baseMapView;
    let queryType = $('#queryType').val();
    let queryLayer = getLayerByName(queryType);

    let viewResolution = map.getView().getResolution();
    let url = queryLayer.getSource().getGetFeatureInfoUrl(
        coords,
        viewResolution,
        'EPSG:4490',
        {
            'INFO_FORMAT': 'application/json',//geoserver支持jsonp才能输出为jsonp的格式
            'FEATURE_COUNT': 50     //点击查询能返回的数量上限
        });
    if (!map.getOverlayById('popup')) {
        $('#popupPanel').append('<div id="popupElement" title="岸线数字化监管" style="text-align: center"></div>');
        this.popup =new Overlay({
            id: 'popup',
            element: document.getElementById("popupElement")
        });
        map.addOverlay(this.popup);
    }
    $.ajax({
        type: 'GET',
        url: url,
        success: function (res) {
            let element = this.popup.getElement();
            $(element).popover("destroy");
            if (res.features.length > 0) {
                view.animate({
                    center: coords,
                    duration: 300
                })
                let props = res.features[0].properties;
                this.popup.setPosition(coords);
                element.title = props.name;
                $(element).popover({
                    placement: "top",
                    animation: false,
                    html: true,
                    content: getContent(props)
                });
                $(element).popover("show");
            }
        }
    });
}

//地图中数据查询结果
function getContent(props) {
    let rvcd = props.rvcd == null ? '' : props.rvcd;
    let name = props.name == null ? '' : props.name;
    let hhlx = props.hhlx == null ? '' : props.hhlx;
    let hhjb = props.hhjb == null ? '' : props.hhjb;
    let area_id = props.area_id == null ? '' : props.area_id;
    let area_name = props.area_name == null ? '' : props.area_name;
    let gclx = props.gclx == null ? '' : props.gclx;
    let bak = props.bak == null ? '' : props.bak;

    return '<table class="table table-condensed table-striped"><tr><td class="trkey">rvcd</td><td class="trvalue">' + rvcd +
        '</td></tr><tr><td class="trkey">河流名称</td><td class="trvalue">' + name +
        '</td></tr><tr><td class="trkey">河湖类型</td><td class="trvalue">' + hhlx +
        '</td></tr><tr><td class="trkey">河湖级别</td><td class="trvalue">' + hhjb +
        '</td></tr><tr><td class="trkey">行政区代码</td><td class="trvalue">' + area_id +
        '</td></tr><tr><td class="trkey">行政区名称</td><td class="trvalue">' + area_name +
        '</td></tr><tr><td class="trkey">工程类型</td><td class="trvalue">' + gclx +
        '</td></tr><tr><td class="trkey">备注</td><td class="trvalue">' + bak +
        '</td></tr></table>'
}

let resetToolbarStatus = function () {
    debugger;
    let map = this.baseMapMap;
    if ($('#layerListPanel').css('display') == 'block') {
        $("#layerListPanel").fadeOut();
    }
    if ($('#coordsLocatePanel').css('display') == 'block') {
        $("#coordsLocatePanel").fadeOut();
        resetCoords();
    }
    if ($('#measureToolPanel').css('display') == 'block') {
        $("#measureToolPanel").fadeOut();
        measureTool.closeMeasureTool();
        this.mapClickEvent = map.on('click', mapClick);
    }
    if ($('#queryToolPanel').css('display') == 'block') {
        $("#queryToolPanel").fadeOut();
    }
}
let layerControlClick = function (evt) {
    let display = $('#layerListPanel').css('display');
    if (display == 'block') {
        $("#layerListPanel").fadeOut();
    } else {
        resetToolbarStatus();
        $("#layerListPanel").fadeIn();
    }
}

let layerSwitch = function (layerName, checked) {
    let layers = map.getLayers();
    layers.forEach(function (layer, i) {
        let name = layer.get('name');
        if (name == layerName) {
            layer.setVisible(checked);
            return;
        }
    });
}

let queryToolClick = function (evt) {
    let display = $('#queryToolPanel').css('display');
    if (display == 'block') {
        $("#queryToolPanel").fadeOut();
    } else {
        resetToolbarStatus();
        $("#queryToolPanel").fadeIn();
    }
}

let locByEnterKey = function () {
    if (event.keyCode === 13) {
        coordsLocate();
    }
}

let coordsLocControlClick = function () {
    let display = $('#coordsLocatePanel').css('display');
    if (display == 'block') {
        $('#coordsLocatePanel').fadeOut();
        resetCoords();
    } else {
        resetToolbarStatus();
        $('#coordsLocatePanel').fadeIn();
    }
}
let resetCoords = function () {
    $('#locateX').val("");
    $('#locateY').val("");
}
let coordsLocate = function () {
    let locateX = $('#locateX').val();
    let locateY = $('#locateY').val();
    if (parseFloat(locateX).toString() == "NaN" || parseFloat(locateY).toString() == "NaN") {
        return;
    }
    let coordinate = [];
    coordinate.push(parseFloat(locateX));
    coordinate.push(parseFloat(locateY));
    locateByCoords(coordinate);
}
let locateByCoords = function (coords) {
    let map = this.baseMapMap;
    const zoom = this.baseMapView.getZoom();
    this.baseMapView.animate({
        zoom: zoom - 1,
        duration: 300
    }, {
        center: coords,
        zoom: 16,
        duration: 2000
    })
    if (!map.getOverlayById('locate')) {
        $('#mainMap').append('<div id="locateMarker"></div>');
        this.locate = new Overlay({
            id: 'locate'
        });
        map.addOverlay(this.locate);
    }
    this.locate.setElement(document.getElementById('locateMarker'));
    this.locate.setPosition(coords);

    setTimeout(function () {
        $("#locateMarker").css('display', 'block');
    }, 2000)
}

let measureToolControlClick = function () {
    let display = $('#measureToolPanel').css('display');
    if (display == 'block') {
        $('#measureToolPanel').fadeOut();
        measureTool.closeMeasureTool();
        this.mapClickEvent = map.on('click', mapClick);
    } else {
        resetToolbarStatus();
        $('#measureToolPanel').fadeIn();
        measureTool.initMeasureTool();
        unByKey(this.mapClickEvent);
    }
}

let clearMapOverlays = function () {
    if (source) {
        source = null;
        vector.setSource(source);
    }
    map.getOverlays().clear();
    map.removeInteraction(draw);
    if ($('#measureToolPanel').css('display') == 'block') {
        addInteraction();
    }
}

let setLayerOpacity = function (layerName, value) {
    let layers = map.getLayers();
    layers.forEach(function (layer, i) {
        let name = layer.get('name');
        if (name == layerName) {
            layer.setOpacity(value);
            return;
        }
    });
}

//缩放到初始位置（自带的zoomToExtent控件只能缩放至整数zoom级别）
function zoomToFullExtent(view) {
    if (!view) return;
    view.animate({
        zoom: 9.5,
        center: [116.689, 37.238],
        duration: 300,
        rotation: 0
    })
}

//设置透明度
function setPanelOpacity(value) {
    if (parseFloat(value).toString() != "NaN") {
        $("#listPanel").css("opacity", value);
        $("#queryToolPanel").css("opacity", value);
        $("#chartPanel").css("opacity", value);
        $("#layerListPanel").css("opacity", value);
        $("#measureToolPanel").css("opacity", value);
        $("#toolBar").css("opacity", value);
    }
}

export {markerClick, mapClick,layerControlClick,queryToolClick,coordsLocControlClick,zoomToFullExtent,
    measureToolControlClick,clearMapOverlays,setLayerOpacity,setPanelOpacity,coordsLocate,resetCoords,layerSwitch}