import TileLayer from 'ol/layer/Tile'
import ImageLayer from 'ol/layer/Image'
import LayerGroup from 'ol/layer/Group'
import WMTS from 'ol/source/WMTS'
import TileImage from 'ol/source/TileImage'
import TileGrid from 'ol/tilegrid/TileGrid'
import WMTSGrid from 'ol/tilegrid/WMTS'
import ImageWMS from 'ol/source/ImageWMS'

import {getWidth, getTopLeft} from 'ol/extent'
import {get as getProjection} from 'ol/proj'
import $ from "jquery";


const gjtdt_tk = "62514babef7d0676e489326d945946e4";
const layerOpacity_default = 1;
const layerVisible_default = true;
let imgLayer;
let vecLayer;
let sdtdt_vec;
let sdtdt_img;
let sdtdt_cia;
let xzqLayer;

export function getWMTSGrid(proj) {
    const tileSizePixels = 256;
    const projection = getProjection(proj)
    const projectionExtent = projection.getExtent();
    const size = getWidth(projectionExtent) / tileSizePixels
    const matrixIds = [];
    const resolutions = [];
    for (let i = 0; i <= 20; i++) {
        matrixIds[i] = i;
        resolutions[i] = size / Math.pow(2, i);
    }
    return new WMTSGrid({
        origin: getTopLeft(projectionExtent),
        resolutions: resolutions,
        matrixIds: matrixIds
    });
}

export function createTDTWMTSLayer(type, proj, opacity, visible) {
    let layerOpacity = opacity ? opacity : layerOpacity_default;
    let layerVisible = visible ? visible : layerVisible_default;
    let projection = getProjection(proj);
    if (!projection) {
        return null;
    }
    const tileGrid = getWMTSGrid(proj);
    let layer = new TileLayer({
        opacity: layerOpacity,
        preload: Infinity,
        source: new WMTS({
            url: 'http://t' + Math.round(Math.random() * 7) + '.tianditu.com/' + type + '/wmts?tk=' + gjtdt_tk,
            layer: type.substr(0, 3),
            matrixSet: type.substring(4),
            format: 'tiles',
            projection: projection,
            tileGrid: tileGrid,
            style: 'default',
            wrapX: true
        }),
        visible: layerVisible
    });
    layer.id = type;
    return layer;
}

export function createSDTDTWMTSLayer(url, type, proj, opacity, visible) {
    let projection = getProjection(proj);
    if (!projection) {
        return null;
    }
    const tileGrid = getWMTSGrid(proj);
    let layer = new TileLayer({
        opacity: opacity,
        source: new WMTS({
            url: url,
            layer: type,
            style: "default",
            matrixSet: proj,
            projection: projection,
            format: "image/png",
            tileGrid: tileGrid,
            wrapX: true
        }),
        visible: visible
    });
    layer.id = type;
    return layer;
}

export function loadBaseLayer(map,defaultType) {
    //国家天地图影像
    imgLayer = createTDTWMTSLayer("img_c", "EPSG:4490", 1, false);
    //国家天地图矢量
    vecLayer = createTDTWMTSLayer("vec_c", "EPSG:4490",false);
    //山东天地图矢量（带注记）
    sdtdt_vec = createSDTDTWMTSLayer("http://www.sdmap.gov.cn/tileservice/SDPubMap", "sdvec", "EPSG:4490", 1, false);
    //山东天地图影像
    sdtdt_img = createSDTDTWMTSLayer("http://www.sdmap.gov.cn/tileservice/SdRasterPubMap", "sdimg", "EPSG:4490", 1, false);
    //山东天地图影像注记
    sdtdt_cia = createSDTDTWMTSLayer("http://www.sdmap.gov.cn/tileservice/SDRasterPubMapDJ", "sdcia", "EPSG:4490", 1, false);
    //德州县级行政区图层
    xzqLayer = new ImageLayer({
        name: 'xjxzq',
        source: new ImageWMS({
            //不能设置为0，否则地图不展示。
            ratio: 1,
            url: 'http://222.133.41.37:9212/geoserver/ows',
            params: {
                LAYERS: 'dzsl:xjxzq'
            },
            serverType: "geoserver"
        }),
        zIndex: 10
    });
    map.addLayer(imgLayer);
    map.addLayer(vecLayer);
    map.addLayer(sdtdt_vec);
    map.addLayer(sdtdt_img);
    map.addLayer(sdtdt_cia);
    map.addLayer(xzqLayer);
    if(defaultType == 'img'){
        imgMapClick();
    }else{
        vecMapClick();
    }
}

//右下角地图切换点击矢量图事件
export function vecMapClick() {
    imgLayer.setVisible(false);
    vecLayer.setVisible(true);
    sdtdt_vec.setVisible(true);
    sdtdt_img.setVisible(false);
    sdtdt_cia.setVisible(false);
    $("#vecMap").css('border-color', '#409eff');
    $("#imgMap").css('border-color', '#ffffff');
}

//右下角地图切换点击影像图事件
export function imgMapClick() {
    imgLayer.setVisible(true);
    vecLayer.setVisible(false);
    sdtdt_vec.setVisible(false);
    sdtdt_img.setVisible(true);
    sdtdt_cia.setVisible(true);
    $("#imgMap").css('border-color', '#409eff');
    $("#vecMap").css('border-color', '#ffffff');
}