/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.util;

import com.jeecg.weibo.dto.WeiBoMentionsDto;
import com.jeecg.weibo.dto.WeiboUserTimelineDto;
import com.jeecg.weibo.exception.BusinessException;
import org.apache.commons.lang.StringUtils;

public class WeiboStatusesUtil {
    public static void getUserTimelineParmValidate(WeiboUserTimelineDto userTimeline) {
        if (StringUtils.isEmpty((String)userTimeline.getAccess_token())) {
            throw new BusinessException("access_token \u4e0d\u80fd \u4e3a\u7a7a");
        }
    }

    public static String getUserTimelineUrl(String interUrl, WeiboUserTimelineDto userTimeline) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (StringUtils.isNotEmpty((String)userTimeline.getAccess_token())) {
            requestUrl.append("&access_token=" + userTimeline.getAccess_token());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getUid())) {
            requestUrl.append("&uid=" + userTimeline.getUid());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getScreen_name())) {
            requestUrl.append("&screen_name=" + userTimeline.getScreen_name());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getSince_id())) {
            requestUrl.append("&since_id=" + userTimeline.getSince_id());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getMax_id())) {
            requestUrl.append("&max_id=" + userTimeline.getMax_id());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getCount())) {
            requestUrl.append("&count=" + userTimeline.getCount());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getPage())) {
            requestUrl.append("&page=" + userTimeline.getPage());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getBase_app())) {
            requestUrl.append("&base_app=" + userTimeline.getBase_app());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getFeature())) {
            requestUrl.append("&feature=" + userTimeline.getFeature());
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getTrim_user())) {
            requestUrl.append("trim_user=" + userTimeline.getTrim_user());
        }
        return requestUrl.toString();
    }

    public static void getUserTimelineIdsParmValidate(WeiboUserTimelineDto userTimeline) {
        if (StringUtils.isEmpty((String)userTimeline.getAccess_token())) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)userTimeline.getUid()) && StringUtils.isEmpty((String)userTimeline.getScreen_name())) {
            throw new BusinessException("uid\u4e0escreen_name\u4e8c\u8005\u4e0d\u80fd\u5168\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)userTimeline.getUid()) && StringUtils.isNotEmpty((String)userTimeline.getScreen_name())) {
            throw new BusinessException("uid\u4e0escreen_name\u4e8c\u8005\u53ea\u80fd\u9009\u5176\u4e00");
        }
    }

    public static void getCountParmValidate(String access_token, String ids) {
        if (StringUtils.isEmpty((String)access_token)) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)ids)) {
            throw new BusinessException("\u5fae\u535aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] idArry = ids.split(",");
        if (idArry.length > 100) {
            throw new BusinessException("\u5fae\u535aID\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc7100");
        }
    }

    public static String getCountUrl(String interUrl, String access_token, String ids) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (StringUtils.isNotEmpty((String)access_token)) {
            requestUrl.append("&access_token=" + access_token);
        }
        if (StringUtils.isNotEmpty((String)ids)) {
            requestUrl.append("&ids=" + ids);
        }
        return requestUrl.toString();
    }

    public static void getShowParmValidate(String access_token, String id) {
        if (StringUtils.isEmpty((String)access_token)) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)id)) {
            throw new BusinessException("\u5fae\u535aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] idArry = id.split(",");
        if (idArry.length > 1) {
            throw new BusinessException("\u5fae\u535aID\u4e2a\u6570\u53ea\u80fd\u4e3a1");
        }
    }

    public static String getShowUrl(String interUrl, String access_token, String id) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (StringUtils.isNotEmpty((String)access_token)) {
            requestUrl.append("&access_token=" + access_token);
        }
        if (StringUtils.isNotEmpty((String)id)) {
            requestUrl.append("&id=" + id);
        }
        return requestUrl.toString();
    }

    public static void getMentionsParmValidate(WeiBoMentionsDto mentions) {
        if (StringUtils.isEmpty((String)mentions.getAccess_token())) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static String getMentionsUrl(String interUrl, WeiBoMentionsDto mentions) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (StringUtils.isNotEmpty((String)mentions.getAccess_token())) {
            requestUrl.append("&access_token=" + mentions.getAccess_token());
        }
        if (StringUtils.isNotEmpty((String)mentions.getSince_id())) {
            requestUrl.append("&since_id=" + mentions.getSince_id());
        }
        if (StringUtils.isNotEmpty((String)mentions.getMax_id())) {
            requestUrl.append("&max_id=" + mentions.getMax_id());
        }
        if (StringUtils.isNotEmpty((String)mentions.getCount())) {
            requestUrl.append("&count=" + mentions.getCount());
        }
        if (StringUtils.isNotEmpty((String)mentions.getPage())) {
            requestUrl.append("&page=" + mentions.getPage());
        }
        if (StringUtils.isNotEmpty((String)mentions.getFilter_by_author())) {
            requestUrl.append("&filter_by_author=" + mentions.getFilter_by_author());
        }
        if (StringUtils.isNotEmpty((String)mentions.getFilter_by_source())) {
            requestUrl.append("&filter_by_source=" + mentions.getFilter_by_source());
        }
        if (StringUtils.isNotEmpty((String)mentions.getFilter_by_type())) {
            requestUrl.append("&filter_by_type=" + mentions.getFilter_by_type());
        }
        return requestUrl.toString();
    }
}

