/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.interceptor;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.modules.jmreport.common.annotation.JimuLoginRequired;
import org.jeecg.modules.jmreport.common.b.g;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuReportInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuReportInterceptor.class);
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    public static final String[] XSS_KEYWORD = new String[]{"<", "%3C", ">", "%3E", "\\(", "%28", "\\)", "%29", "'", "eval\\((.*)\\)"};

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        String string = this.filterUrl(request.getRequestURI().substring(request.getContextPath().length()));
        log.debug("JimuReportInterceptor check requestPath = " + string);
        if (this.hasXssKeyWord(string)) {
            log.error("\u8bf7\u6ce8\u610f\uff0c\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669\uff01" + string);
            this.backError(response, "\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669!");
            return false;
        }
        String string2 = this.jmBaseConfig.getCustomPrePath();
        log.debug("customPrePath: {}", (Object)string2);
        if (g.d((Object)string2) && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        request.setAttribute("customPrePath", (Object)string2);
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        JimuLoginRequired jimuLoginRequired = method.getAnnotation(JimuLoginRequired.class);
        if (g.d(jimuLoginRequired) && jimuLoginRequired.required() && !this.verifyToken(request)) {
            log.error("Token\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + string);
            this.backError(response, "Token\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
            return false;
        }
        return true;
    }

    private boolean hasXssKeyWord(String requestPath) {
        for (String string : XSS_KEYWORD) {
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(requestPath);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private boolean verifyToken(HttpServletRequest request) {
        return this.jimuTokenClient.verifyToken(request);
    }

    private String filterUrl(String requestPath) {
        String string = "";
        if (g.d((Object)requestPath)) {
            string = requestPath.replace("\\", "/");
            if ((string = string.replace("//", "/")).indexOf("//") >= 0) {
                string = this.filterUrl(string);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backError(HttpServletResponse response, String msg) {
        PrintWriter printWriter = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("auth", "fail");
        try {
            printWriter = response.getWriter();
            Result<Object> result = Result.error(msg);
            printWriter.print(JSON.toJSON(result));
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

