/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JmExpression {
    public static final String REGEX = "^=${expression}\\((.*)\\.(.*)\\)$";
    public static final String[] EXP_TYPES = new String[]{"DBSUM", "DBMAX", "DBMIN", "DBAVERAGE", "dbsum", "dbmax", "dbmin", "dbaverage"};
    public static final String REPLACE_STR = "${expression}";
    private String text;
    private String value;
    private String type;
    private String dbCode;
    private String field;

    public JmExpression() {
    }

    public JmExpression(String str) {
        this.text = str;
        this.value = "";
        for (int i2 = 0; i2 < EXP_TYPES.length; ++i2) {
            String string;
            Pattern pattern;
            Matcher matcher;
            String string2 = EXP_TYPES[i2];
            if (str.indexOf(string2) <= 0 || !(matcher = (pattern = Pattern.compile(string = REGEX.replace(REPLACE_STR, string2))).matcher(str)).find()) continue;
            this.type = string2;
            this.dbCode = matcher.group(1);
            this.field = matcher.group(2);
            break;
        }
    }

    public String getFullSql(String metaSql, String condition) {
        String string = "";
        String string2 = this.type.toUpperCase();
        if (EXP_TYPES[0].equals(string2)) {
            string = "SELECT sum(" + this.field + ") askey from ( " + metaSql + " )";
        } else if (EXP_TYPES[1].equals(string2)) {
            string = "SELECT max(" + this.field + ") askey from ( " + metaSql + " )";
        } else if (EXP_TYPES[2].equals(string2)) {
            string = "SELECT min(" + this.field + ") askey from ( " + metaSql + " )";
        } else if (EXP_TYPES[3].equals(string2)) {
            string = "SELECT avg(" + this.field + ") askey from ( " + metaSql + " )";
        }
        string = string + "jeecg_rp_temp";
        if (condition != null && !"".equals(condition)) {
            string = string + " where 1=1 " + condition;
        }
        return string;
    }

    public static Map<String, String> getExpMapByList(List<JmExpression> expList) {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        for (JmExpression jmExpression : expList) {
            hashMap.put(jmExpression.getText(), jmExpression.getValue());
            hashMap.put(jmExpression.getText().replace(jmExpression.getType(), jmExpression.getType().toLowerCase()), jmExpression.getValue());
        }
        return hashMap;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getDbCode() {
        return this.dbCode;
    }

    public String getField() {
        return this.field;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDbCode(String dbCode) {
        this.dbCode = dbCode;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof JmExpression)) {
            return false;
        }
        JmExpression jmExpression = (JmExpression)o2;
        if (!jmExpression.canEqual(this)) {
            return false;
        }
        String string = this.getText();
        String string2 = jmExpression.getText();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getValue();
        String string4 = jmExpression.getValue();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getType();
        String string6 = jmExpression.getType();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getDbCode();
        String string8 = jmExpression.getDbCode();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getField();
        String string10 = jmExpression.getField();
        return !(string9 == null ? string10 != null : !string9.equals(string10));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JmExpression;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        String string = this.getText();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getValue();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getType();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getDbCode();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getField();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        return n3;
    }

    public String toString() {
        return "JmExpression(text=" + this.getText() + ", value=" + this.getValue() + ", type=" + this.getType() + ", dbCode=" + this.getDbCode() + ", field=" + this.getField() + ")";
    }
}

